/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.manager.partition;

import java.util.List;
import java.util.Objects;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.commons.cluster.RegionStatus;
import org.apache.iotdb.commons.service.metric.enums.Metric;
import org.apache.iotdb.commons.service.metric.enums.Tag;
import org.apache.iotdb.commons.utils.NodeUrlUtils;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.manager.IManager;
import org.apache.iotdb.confignode.manager.load.LoadManager;
import org.apache.iotdb.confignode.manager.node.NodeManager;
import org.apache.iotdb.confignode.manager.partition.PartitionManager;
import org.apache.iotdb.confignode.manager.schema.ClusterSchemaManager;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionMetrics
implements IMetricSet {
    private static final Logger LOGGER = LoggerFactory.getLogger(PartitionMetrics.class);
    private static final String DATA = "data";
    private static final String SCHEMA = "schema";
    private final IManager configManager;

    public PartitionMetrics(IManager configManager) {
        this.configManager = configManager;
    }

    public void bindTo(AbstractMetricService metricService) {
        this.bindRegionPartitionMetrics(metricService);
        this.bindDataNodePartitionMetrics(metricService);
        this.bindDatabaseRelatedMetrics(metricService);
    }

    public void unbindFrom(AbstractMetricService metricService) {
        this.unbindRegionPartitionMetrics(metricService);
        this.unbindDataNodePartitionMetrics(metricService);
        this.unbindDatabaseRelatedMetrics(metricService);
    }

    private void bindDataNodePartitionMetrics(AbstractMetricService metricService) {
        List<TDataNodeConfiguration> registerDataNodes = this.getNodeManager().getRegisteredDataNodes();
        for (TDataNodeConfiguration dataNodeConfiguration : registerDataNodes) {
            int dataNodeId = dataNodeConfiguration.getLocation().getDataNodeId();
            PartitionMetrics.bindDataNodePartitionMetricsWhenUpdate(metricService, this.configManager, dataNodeId);
        }
    }

    private void unbindDataNodePartitionMetrics(AbstractMetricService metricService) {
        List<TDataNodeConfiguration> registerDataNodes = this.getNodeManager().getRegisteredDataNodes();
        for (TDataNodeConfiguration dataNodeConfiguration : registerDataNodes) {
            String dataNodeName = NodeUrlUtils.convertTEndPointUrl((TEndPoint)dataNodeConfiguration.getLocation().getClientRpcEndPoint());
            PartitionMetrics.unbindDataNodePartitionMetricsWhenUpdate(metricService, dataNodeName);
        }
    }

    public static void bindDataNodePartitionMetricsWhenUpdate(AbstractMetricService metricService, IManager configManager, int dataNodeId) {
        NodeManager nodeManager = configManager.getNodeManager();
        PartitionManager partitionManager = configManager.getPartitionManager();
        LoadManager loadManager = configManager.getLoadManager();
        String dataNodeName = NodeUrlUtils.convertTEndPointUrl((TEndPoint)nodeManager.getRegisteredDataNode(dataNodeId).getLocation().getClientRpcEndPoint());
        metricService.createAutoGauge(Metric.REGION_NUM_IN_DATA_NODE.toString(), MetricLevel.CORE, (Object)partitionManager, obj -> obj.getRegionCount(dataNodeId, TConsensusGroupType.SchemaRegion), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.createAutoGauge(Metric.REGION_NUM_IN_DATA_NODE.toString(), MetricLevel.CORE, (Object)partitionManager, obj -> obj.getRegionCount(dataNodeId, TConsensusGroupType.DataRegion), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
        metricService.createAutoGauge(Metric.REGION_GROUP_LEADER_NUM_IN_DATA_NODE.toString(), MetricLevel.CORE, (Object)loadManager, obj -> obj.getRegionGroupLeaderCount(dataNodeId, TConsensusGroupType.SchemaRegion), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.createAutoGauge(Metric.REGION_GROUP_LEADER_NUM_IN_DATA_NODE.toString(), MetricLevel.CORE, (Object)loadManager, obj -> obj.getRegionGroupLeaderCount(dataNodeId, TConsensusGroupType.DataRegion), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
        metricService.createAutoGauge(Metric.SCATTER_WIDTH_NUM_IN_DATA_NODE.toString(), MetricLevel.CORE, (Object)partitionManager, obj -> obj.countDataNodeScatterWidth(dataNodeId, TConsensusGroupType.SchemaRegion), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.createAutoGauge(Metric.SCATTER_WIDTH_NUM_IN_DATA_NODE.toString(), MetricLevel.CORE, (Object)partitionManager, obj -> obj.countDataNodeScatterWidth(dataNodeId, TConsensusGroupType.DataRegion), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
    }

    public static void unbindDataNodePartitionMetricsWhenUpdate(AbstractMetricService metricService, String dataNodeName) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_NUM_IN_DATA_NODE.toString(), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_NUM_IN_DATA_NODE.toString(), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_GROUP_LEADER_NUM_IN_DATA_NODE.toString(), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_GROUP_LEADER_NUM_IN_DATA_NODE.toString(), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCATTER_WIDTH_NUM_IN_DATA_NODE.toString(), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SCATTER_WIDTH_NUM_IN_DATA_NODE.toString(), new String[]{Tag.NAME.toString(), dataNodeName, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
    }

    private void bindRegionPartitionMetrics(AbstractMetricService metricService) {
        for (RegionStatus status : RegionStatus.values()) {
            metricService.createAutoGauge(Metric.REGION_NUM.toString(), MetricLevel.CORE, (Object)this.getLoadManager(), loadManager -> loadManager.countRegionWithSpecifiedStatus(TConsensusGroupType.SchemaRegion, status), new String[]{Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString(), Tag.STATUS.toString(), status.getStatus()});
            metricService.createAutoGauge(Metric.REGION_NUM.toString(), MetricLevel.CORE, (Object)this.getLoadManager(), loadManager -> loadManager.countRegionWithSpecifiedStatus(TConsensusGroupType.DataRegion, status), new String[]{Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString(), Tag.STATUS.toString(), status.getStatus()});
        }
    }

    private void unbindRegionPartitionMetrics(AbstractMetricService metricService) {
        for (RegionStatus status : RegionStatus.values()) {
            metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_NUM.toString(), new String[]{Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString(), Tag.STATUS.toString(), status.getStatus()});
            metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_NUM.toString(), new String[]{Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString(), Tag.STATUS.toString(), status.getStatus()});
        }
    }

    private void bindDatabaseRelatedMetrics(AbstractMetricService metricService) {
        ClusterSchemaManager clusterSchemaManager = this.getClusterSchemaManager();
        metricService.createAutoGauge(Metric.DATABASE_NUM.toString(), MetricLevel.CORE, (Object)clusterSchemaManager, c -> c.getDatabaseNames().size(), new String[0]);
        List<String> databases = clusterSchemaManager.getDatabaseNames();
        for (String database : databases) {
            int dataReplicationFactor = 1;
            int schemaReplicationFactor = 1;
            try {
                dataReplicationFactor = clusterSchemaManager.getReplicationFactor(database, TConsensusGroupType.DataRegion);
                schemaReplicationFactor = clusterSchemaManager.getReplicationFactor(database, TConsensusGroupType.SchemaRegion);
            }
            catch (DatabaseNotExistsException databaseNotExistsException) {
                // empty catch block
            }
            PartitionMetrics.bindDatabaseRelatedMetricsWhenUpdate(metricService, this.configManager, database, dataReplicationFactor, schemaReplicationFactor);
        }
    }

    private void unbindDatabaseRelatedMetrics(AbstractMetricService metricService) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.DATABASE_NUM.toString(), new String[0]);
        List<String> databases = this.getClusterSchemaManager().getDatabaseNames();
        for (String database : databases) {
            PartitionMetrics.unbindDatabaseRelatedMetricsWhenUpdate(metricService, database);
        }
    }

    public static void bindDatabaseRelatedMetricsWhenUpdate(AbstractMetricService metricService, IManager configManager, String database, int dataReplicationFactor, int schemaReplicationFactor) {
        PartitionMetrics.bindDatabasePartitionMetricsWhenUpdate(metricService, configManager, database);
        PartitionMetrics.bindDatabaseReplicationFactorMetricsWhenUpdate(metricService, database, dataReplicationFactor, schemaReplicationFactor);
    }

    private static void bindDatabasePartitionMetricsWhenUpdate(AbstractMetricService metricService, IManager configManager, String database) {
        PartitionManager partitionManager = configManager.getPartitionManager();
        metricService.createAutoGauge(Metric.SERIES_SLOT_NUM_IN_DATABASE.toString(), MetricLevel.CORE, (Object)partitionManager, manager -> manager.getAssignedSeriesPartitionSlotsCount(database), new String[]{Tag.NAME.toString(), database});
        metricService.createAutoGauge(Metric.TIME_SLOT_NUM_IN_DATABASE.toString(), MetricLevel.CORE, (Object)partitionManager, manager -> manager.getAssignedTimePartitionSlotsCount(database), new String[]{Tag.NAME.toString(), database});
        metricService.createAutoGauge(Metric.REGION_GROUP_NUM_IN_DATABASE.toString(), MetricLevel.CORE, (Object)partitionManager, manager -> {
            try {
                return manager.getRegionGroupCount(database, TConsensusGroupType.SchemaRegion);
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.info("Error when counting SchemaRegionGroups in Database: {}", (Object)database, (Object)e);
                return 0.0;
            }
        }, new String[]{Tag.NAME.toString(), database, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.createAutoGauge(Metric.REGION_GROUP_NUM_IN_DATABASE.toString(), MetricLevel.CORE, (Object)partitionManager, manager -> {
            try {
                return manager.getRegionGroupCount(database, TConsensusGroupType.DataRegion);
            }
            catch (DatabaseNotExistsException e) {
                LOGGER.info("Error when counting DataRegionGroups in Database: {}", (Object)database, (Object)e);
                return 0.0;
            }
        }, new String[]{Tag.NAME.toString(), database, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
    }

    public static void unbindDatabaseRelatedMetricsWhenUpdate(AbstractMetricService metricService, String database) {
        metricService.remove(MetricType.AUTO_GAUGE, Metric.SERIES_SLOT_NUM_IN_DATABASE.toString(), new String[]{Tag.NAME.toString(), database});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.TIME_SLOT_NUM_IN_DATABASE.toString(), new String[]{Tag.NAME.toString(), database});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_GROUP_NUM_IN_DATABASE.toString(), new String[]{Tag.NAME.toString(), database, Tag.TYPE.toString(), TConsensusGroupType.SchemaRegion.toString()});
        metricService.remove(MetricType.AUTO_GAUGE, Metric.REGION_GROUP_NUM_IN_DATABASE.toString(), new String[]{Tag.NAME.toString(), database, Tag.TYPE.toString(), TConsensusGroupType.DataRegion.toString()});
        metricService.remove(MetricType.GAUGE, Metric.REPLICATION_FACTOR.toString(), new String[]{Tag.TYPE.toString(), DATA, Tag.DATABASE.toString(), database});
        metricService.remove(MetricType.GAUGE, Metric.REPLICATION_FACTOR.toString(), new String[]{Tag.TYPE.toString(), SCHEMA, Tag.DATABASE.toString(), database});
    }

    public static void bindDatabaseReplicationFactorMetricsWhenUpdate(AbstractMetricService metricService, String database, int dataReplicationFactor, int schemaReplicationFactor) {
        metricService.getOrCreateGauge(Metric.REPLICATION_FACTOR.toString(), MetricLevel.CORE, new String[]{Tag.TYPE.toString(), DATA, Tag.DATABASE.toString(), database}).set((long)dataReplicationFactor);
        metricService.getOrCreateGauge(Metric.REPLICATION_FACTOR.toString(), MetricLevel.CORE, new String[]{Tag.TYPE.toString(), SCHEMA, Tag.DATABASE.toString(), database}).set((long)schemaReplicationFactor);
    }

    private NodeManager getNodeManager() {
        return this.configManager.getNodeManager();
    }

    private ClusterSchemaManager getClusterSchemaManager() {
        return this.configManager.getClusterSchemaManager();
    }

    private LoadManager getLoadManager() {
        return this.configManager.getLoadManager();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartitionMetrics that = (PartitionMetrics)o;
        return this.configManager.equals(that.configManager);
    }

    public int hashCode() {
        return Objects.hash(this.configManager);
    }
}

