/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.pipe.agent.plugin;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.pipe.agent.plugin.constructor.PipeProcessorConstructor;
import org.apache.iotdb.commons.pipe.agent.plugin.constructor.PipeSinkConstructor;
import org.apache.iotdb.commons.pipe.agent.plugin.constructor.PipeSourceConstructor;
import org.apache.iotdb.commons.pipe.agent.plugin.meta.PipePluginMetaKeeper;
import org.apache.iotdb.commons.pipe.config.plugin.configuraion.PipeTaskRuntimeConfiguration;
import org.apache.iotdb.commons.pipe.config.plugin.env.PipeTaskTemporaryRuntimeEnvironment;
import org.apache.iotdb.pipe.api.PipeConnector;
import org.apache.iotdb.pipe.api.PipeExtractor;
import org.apache.iotdb.pipe.api.PipeProcessor;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeConnectorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.configuration.PipeProcessorRuntimeConfiguration;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameterValidator;
import org.apache.iotdb.pipe.api.customizer.parameter.PipeParameters;
import org.apache.iotdb.pipe.api.exception.PipeException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class PipePluginAgent {
    private static final Logger LOGGER = LoggerFactory.getLogger(PipePluginAgent.class);
    protected final PipePluginMetaKeeper pipePluginMetaKeeper;
    private final PipeSourceConstructor pipeSourceConstructor;
    private final PipeProcessorConstructor pipeProcessorConstructor;
    private final PipeSinkConstructor pipeSinkConstructor;

    protected PipePluginAgent(PipePluginMetaKeeper pipePluginMetaKeeper) {
        this.pipePluginMetaKeeper = pipePluginMetaKeeper;
        this.pipeSourceConstructor = this.createPipeExtractorConstructor(pipePluginMetaKeeper);
        this.pipeProcessorConstructor = this.createPipeProcessorConstructor(pipePluginMetaKeeper);
        this.pipeSinkConstructor = this.createPipeConnectorConstructor(pipePluginMetaKeeper);
    }

    protected abstract PipeSourceConstructor createPipeExtractorConstructor(PipePluginMetaKeeper var1);

    protected abstract PipeProcessorConstructor createPipeProcessorConstructor(PipePluginMetaKeeper var1);

    protected abstract PipeSinkConstructor createPipeConnectorConstructor(PipePluginMetaKeeper var1);

    public final PipeExtractor reflectExtractor(PipeParameters extractorParameters) {
        return this.pipeSourceConstructor.reflectPlugin(extractorParameters);
    }

    public final PipeProcessor reflectProcessor(PipeParameters processorParameters) {
        return this.pipeProcessorConstructor.reflectPlugin(processorParameters);
    }

    public final PipeConnector reflectConnector(PipeParameters connectorParameters) {
        return this.pipeSinkConstructor.reflectPlugin(connectorParameters);
    }

    public void validate(String pipeName, Map<String, String> extractorAttributes, Map<String, String> processorAttributes, Map<String, String> connectorAttributes) throws Exception {
        this.validateExtractor(extractorAttributes);
        this.validateProcessor(processorAttributes);
        this.validateConnector(pipeName, connectorAttributes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateExtractor(Map<String, String> extractorAttributes) throws Exception {
        PipeParameters extractorParameters = new PipeParameters(extractorAttributes);
        PipeExtractor temporaryExtractor = this.reflectExtractor(extractorParameters);
        try {
            temporaryExtractor.validate(new PipeParameterValidator(extractorParameters));
        }
        finally {
            try {
                temporaryExtractor.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close temporary extractor: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateProcessor(Map<String, String> processorAttributes) throws Exception {
        PipeParameters processorParameters = new PipeParameters(processorAttributes);
        PipeProcessor temporaryProcessor = this.reflectProcessor(processorParameters);
        try {
            temporaryProcessor.validate(new PipeParameterValidator(processorParameters));
        }
        finally {
            try {
                temporaryProcessor.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close temporary processor: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateConnector(String pipeName, Map<String, String> connectorAttributes) throws Exception {
        PipeParameters connectorParameters = new PipeParameters(connectorAttributes);
        PipeConnector temporaryConnector = this.reflectConnector(connectorParameters);
        try {
            temporaryConnector.validate(new PipeParameterValidator(connectorParameters));
            temporaryConnector.customize(connectorParameters, (PipeConnectorRuntimeConfiguration)new PipeTaskRuntimeConfiguration(new PipeTaskTemporaryRuntimeEnvironment(pipeName)));
            temporaryConnector.handshake();
        }
        finally {
            try {
                temporaryConnector.close();
            }
            catch (Exception e) {
                LOGGER.warn("Failed to close temporary connector: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public final List<String> getSubProcessorNamesWithSpecifiedParent(Class<? extends PipeProcessor> parentClass) throws PipeException {
        return Arrays.stream(this.pipePluginMetaKeeper.getAllPipePluginMeta()).map(pipePluginMeta -> pipePluginMeta.getPluginName().toLowerCase()).filter(pluginName -> {
            boolean bl;
            block8: {
                PipeProcessor processor = (PipeProcessor)this.pipeProcessorConstructor.reflectPluginByKey((String)pluginName);
                try {
                    boolean bl2 = bl = processor.getClass().getSuperclass() == parentClass;
                    if (processor == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (processor != null) {
                            try {
                                processor.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        return false;
                    }
                }
                processor.close();
            }
            return bl;
        }).collect(Collectors.toList());
    }

    public final PipeProcessor getConfiguredProcessor(String pipeProcessorName, PipeParameters processorParameters, PipeProcessorRuntimeConfiguration runtimeConfigurations) {
        HashMap<String, String> processorKeyMap = new HashMap<String, String>();
        if (Objects.nonNull(pipeProcessorName)) {
            processorKeyMap.put("processor", pipeProcessorName);
        }
        PipeParameters replacedParameters = processorParameters.addOrReplaceEquivalentAttributesWithClone(new PipeParameters(processorKeyMap));
        PipeProcessor processor = this.reflectProcessor(replacedParameters);
        try {
            processor.validate(new PipeParameterValidator(replacedParameters));
            processor.customize(replacedParameters, runtimeConfigurations);
            return processor;
        }
        catch (Exception e) {
            try {
                processor.close();
            }
            catch (Exception closeException) {
                LOGGER.warn("Failed to close processor after failed to initialize processor. Ignore this exception.", (Throwable)closeException);
            }
            throw new PipeException(e.getMessage(), (Throwable)e);
        }
    }
}

