/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.base.CharMatcher;
import com.google.common.io.BaseEncoding;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Locale;
import java.util.Objects;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Literal;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;
import org.apache.iotdb.db.queryengine.plan.relational.sql.parser.ParsingException;
import org.apache.tsfile.utils.Binary;
import org.apache.tsfile.utils.ReadWriteIOUtils;

public class BinaryLiteral
extends Literal {
    private static final CharMatcher WHITESPACE_MATCHER = CharMatcher.whitespace();
    private static final CharMatcher HEX_DIGIT_MATCHER = CharMatcher.inRange((char)'A', (char)'F').or(CharMatcher.inRange((char)'0', (char)'9')).precomputed();
    private final byte[] value;

    public BinaryLiteral(String value) {
        super(null);
        Objects.requireNonNull(value, "value is null");
        String hexString = WHITESPACE_MATCHER.removeFrom((CharSequence)value).toUpperCase(Locale.ENGLISH);
        if (!HEX_DIGIT_MATCHER.matchesAllOf((CharSequence)hexString)) {
            throw new ParsingException("Binary literal can only contain hexadecimal digits");
        }
        if (hexString.length() % 2 != 0) {
            throw new ParsingException("Binary literal must contain an even number of digits");
        }
        this.value = BaseEncoding.base16().decode((CharSequence)hexString);
    }

    public BinaryLiteral(byte[] value) {
        super(null);
        Objects.requireNonNull(value, "value is null");
        this.value = value;
    }

    public BinaryLiteral(NodeLocation location, String value) {
        super(Objects.requireNonNull(location, "location is null"));
        Objects.requireNonNull(value, "value is null");
        String hexString = WHITESPACE_MATCHER.removeFrom((CharSequence)value).toUpperCase(Locale.ENGLISH);
        if (!HEX_DIGIT_MATCHER.matchesAllOf((CharSequence)hexString)) {
            throw new ParsingException("Binary literal can only contain hexadecimal digits", location);
        }
        if (hexString.length() % 2 != 0) {
            throw new ParsingException("Binary literal must contain an even number of digits", location);
        }
        this.value = BaseEncoding.base16().decode((CharSequence)hexString);
    }

    public String toHexString() {
        return BaseEncoding.base16().encode(this.value);
    }

    public byte[] getValue() {
        return (byte[])this.value.clone();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBinaryLiteral(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BinaryLiteral that = (BinaryLiteral)o;
        return Arrays.equals(this.value, that.value);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.value);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!BinaryLiteral.sameClass(this, other)) {
            return false;
        }
        return Arrays.equals(this.value, ((BinaryLiteral)other).value);
    }

    @Override
    public TableExpressionType getExpressionType() {
        return TableExpressionType.BINARY_LITERAL;
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.value.length, (OutputStream)stream);
        for (byte b : this.value) {
            ReadWriteIOUtils.write((byte)b, (OutputStream)stream);
        }
    }

    public BinaryLiteral(ByteBuffer byteBuffer) {
        super(null);
        int length = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.value = new byte[length];
        for (int i = 0; i < length; ++i) {
            this.value[i] = ReadWriteIOUtils.readByte((ByteBuffer)byteBuffer);
        }
    }

    @Override
    public Object getTsValue() {
        return new Binary(this.value);
    }
}

