/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.operator.process;

import com.google.common.util.concurrent.Futures;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.protocol.client.DataNodeInternalClient;
import org.apache.iotdb.db.queryengine.execution.operator.Operator;
import org.apache.iotdb.db.queryengine.execution.operator.OperatorContext;
import org.apache.iotdb.db.queryengine.execution.operator.process.AbstractIntoOperator;
import org.apache.iotdb.db.queryengine.execution.operator.process.InsertTabletStatementGenerator;
import org.apache.iotdb.db.queryengine.execution.operator.process.TreeInsertTabletStatementGenerator;
import org.apache.iotdb.db.queryengine.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.queryengine.plan.statement.crud.InsertTabletStatement;
import org.apache.tsfile.common.conf.TSFileDescriptor;
import org.apache.tsfile.enums.TSDataType;

public abstract class AbstractTreeIntoOperator
extends AbstractIntoOperator {
    protected List<InsertTabletStatementGenerator> insertTabletStatementGenerators;

    protected AbstractTreeIntoOperator(OperatorContext operatorContext, Operator child, List<TSDataType> inputColumnTypes, ExecutorService intoOperationExecutor, long statementSizePerLine) {
        super(operatorContext, child, inputColumnTypes, intoOperationExecutor, statementSizePerLine);
        this.maxReturnSize = TSFileDescriptor.getInstance().getConfig().getMaxTsBlockSizeInBytes();
    }

    protected static List<InsertTabletStatementGenerator> constructInsertTabletStatementGenerators(Map<PartialPath, Map<String, InputLocation>> targetPathToSourceInputLocationMap, Map<PartialPath, Map<String, TSDataType>> targetPathToDataTypeMap, Map<String, Boolean> targetDeviceToAlignedMap, List<TSDataType> inputColumnTypes, int maxRowNumberInStatement) {
        ArrayList<InsertTabletStatementGenerator> insertTabletStatementGenerators = new ArrayList<InsertTabletStatementGenerator>(targetPathToSourceInputLocationMap.size());
        for (Map.Entry<PartialPath, Map<String, InputLocation>> entry : targetPathToSourceInputLocationMap.entrySet()) {
            PartialPath targetDevice = entry.getKey();
            TreeInsertTabletStatementGenerator generator = new TreeInsertTabletStatementGenerator(targetDevice, entry.getValue(), targetPathToDataTypeMap.get(targetDevice), inputColumnTypes, targetDeviceToAlignedMap.get(targetDevice.toString()), maxRowNumberInStatement);
            insertTabletStatementGenerators.add(generator);
        }
        return insertTabletStatementGenerators;
    }

    @Override
    protected void resetInsertTabletStatementGenerators() {
        for (InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
            generator.reset();
        }
    }

    protected long findWritten(String device, String measurement) {
        for (InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
            if (!Objects.equals(generator.getDevice(), device)) continue;
            return generator.getWrittenCount(measurement);
        }
        return 0L;
    }

    protected boolean insertMultiTabletsInternally(boolean needCheck) {
        InsertMultiTabletsStatement insertMultiTabletsStatement = this.constructInsertMultiTabletsStatement(needCheck);
        if (insertMultiTabletsStatement == null) {
            return false;
        }
        this.executeInsertMultiTabletsStatement(insertMultiTabletsStatement);
        return true;
    }

    protected InsertMultiTabletsStatement constructInsertMultiTabletsStatement(boolean needCheck) {
        if (this.insertTabletStatementGenerators == null || needCheck && !this.existFullStatement(this.insertTabletStatementGenerators)) {
            return null;
        }
        ArrayList<InsertTabletStatement> insertTabletStatementList = new ArrayList<InsertTabletStatement>();
        for (InsertTabletStatementGenerator generator : this.insertTabletStatementGenerators) {
            if (generator.isEmpty()) continue;
            insertTabletStatementList.add(generator.constructInsertTabletStatement());
        }
        if (insertTabletStatementList.isEmpty()) {
            return null;
        }
        InsertMultiTabletsStatement insertMultiTabletsStatement = new InsertMultiTabletsStatement();
        insertMultiTabletsStatement.setInsertTabletStatementList(insertTabletStatementList);
        return insertMultiTabletsStatement;
    }

    protected void executeInsertMultiTabletsStatement(InsertMultiTabletsStatement insertMultiTabletsStatement) {
        if (this.client == null) {
            this.client = new DataNodeInternalClient(this.operatorContext.getSessionInfo());
        }
        this.writeOperationFuture = Futures.submit(() -> this.client.insertTablets(insertMultiTabletsStatement), (Executor)this.writeOperationExecutor);
    }

    private boolean existFullStatement(List<InsertTabletStatementGenerator> insertTabletStatementGenerators) {
        for (InsertTabletStatementGenerator generator : insertTabletStatementGenerators) {
            if (!generator.isFull()) continue;
            return true;
        }
        return false;
    }
}

