/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.method;

import eu.timepit.refined.api.RefType$;
import eu.timepit.refined.api.Refined;
import eu.timepit.refined.string;
import java.io.Serializable;
import javax.inject.Inject;
import org.apache.james.jmap.core.CapabilityIdentifier$;
import org.apache.james.jmap.core.ErrorCode$InvalidArguments$;
import org.apache.james.jmap.core.Id;
import org.apache.james.jmap.core.Invocation;
import org.apache.james.jmap.core.Invocation$;
import org.apache.james.jmap.core.Limit$;
import org.apache.james.jmap.core.Position$;
import org.apache.james.jmap.core.QueryState$;
import org.apache.james.jmap.core.SessionTranslator;
import org.apache.james.jmap.json.QuotaSerializer$;
import org.apache.james.jmap.json.ResponseSerializer$;
import org.apache.james.jmap.mail.JmapQuota;
import org.apache.james.jmap.mail.QuotaName;
import org.apache.james.jmap.mail.QuotaQueryFilter;
import org.apache.james.jmap.mail.QuotaQueryRequest;
import org.apache.james.jmap.mail.QuotaQueryResponse;
import org.apache.james.jmap.method.InvocationWithContext;
import org.apache.james.jmap.method.JmapQuotaManagerWrapper;
import org.apache.james.jmap.method.Method;
import org.apache.james.jmap.method.MethodRequiringAccountId;
import org.apache.james.jmap.routes.SessionSupplier;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.quota.QuotaManager;
import org.apache.james.mailbox.quota.UserQuotaRootResolver;
import org.apache.james.metrics.api.MetricFactory;
import org.reactivestreams.Publisher;
import play.api.libs.json.JsError;
import play.api.libs.json.JsValue;
import reactor.core.scala.publisher.SMono;
import reactor.core.scala.publisher.SMono$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0005\u0005]g\u0001\u0002\f\u0018\u0001\tB\u0001b\r\u0001\u0003\u0006\u0004%\t\u0001\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005k!Aa\b\u0001BC\u0002\u0013\u0005q\b\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003A\u0011!9\u0005A!b\u0001\n\u0003A\u0005\u0002C(\u0001\u0005\u0003\u0005\u000b\u0011B%\t\u0011A\u0003!Q1A\u0005\u0002EC\u0001B\u0017\u0001\u0003\u0002\u0003\u0006IA\u0015\u0005\t7\u0002\u0011)\u0019!C\u00019\"A\u0001\r\u0001B\u0001B\u0003%Q\fC\u0003b\u0001\u0011\u0005!\rC\u0004s\u0001\t\u0007I\u0011I:\t\rm\u0004\u0001\u0015!\u0003u\u0011\u001da\bA1A\u0005BuDq!!\u000e\u0001A\u0003%a\u0010C\u0005\u00028\u0001\u0011\r\u0011\"\u0001\u0002:!A\u0011\u0011\t\u0001!\u0002\u0013\tY\u0004C\u0004\u0002D\u0001!\t%!\u0012\t\u000f\u0005E\u0004\u0001\"\u0011\u0002t!9\u0011q\u0013\u0001\u0005\n\u0005e\u0005bBA\\\u0001\u0011%\u0011\u0011\u0018\u0002\u0011#V|G/Y)vKJLX*\u001a;i_\u0012T!\u0001G\r\u0002\r5,G\u000f[8e\u0015\tQ2$\u0001\u0003k[\u0006\u0004(B\u0001\u000f\u001e\u0003\u0015Q\u0017-\\3t\u0015\tqr$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002A\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aI\u0015\u0011\u0005\u0011:S\"A\u0013\u000b\u0003\u0019\nQa]2bY\u0006L!\u0001K\u0013\u0003\r\u0005s\u0017PU3g!\rQ3&L\u0007\u0002/%\u0011Af\u0006\u0002\u0019\u001b\u0016$\bn\u001c3SKF,\u0018N]5oO\u0006\u001b7m\\;oi&#\u0007C\u0001\u00182\u001b\u0005y#B\u0001\u0019\u001a\u0003\u0011i\u0017-\u001b7\n\u0005Iz#!E)v_R\f\u0017+^3ssJ+\u0017/^3ti\u0006iQ.\u001a;sS\u000e4\u0015m\u0019;pef,\u0012!\u000e\t\u0003mmj\u0011a\u000e\u0006\u0003qe\n1!\u00199j\u0015\tQ4$A\u0004nKR\u0014\u0018nY:\n\u0005q:$!D'fiJL7MR1di>\u0014\u00180\u0001\bnKR\u0014\u0018n\u0019$bGR|'/\u001f\u0011\u0002\u001fM,7o]5p]N+\b\u000f\u001d7jKJ,\u0012\u0001\u0011\t\u0003\u0003\u0012k\u0011A\u0011\u0006\u0003\u0007f\taA]8vi\u0016\u001c\u0018BA#C\u0005=\u0019Vm]:j_:\u001cV\u000f\u001d9mS\u0016\u0014\u0018\u0001E:fgNLwN\\*vaBd\u0017.\u001a:!\u0003E\u0019Xm]:j_:$&/\u00198tY\u0006$xN]\u000b\u0002\u0013B\u0011!*T\u0007\u0002\u0017*\u0011A*G\u0001\u0005G>\u0014X-\u0003\u0002O\u0017\n\t2+Z:tS>tGK]1og2\fGo\u001c:\u0002%M,7o]5p]R\u0013\u0018M\\:mCR|'\u000fI\u0001\rcV|G/Y'b]\u0006<WM]\u000b\u0002%B\u00111\u000bW\u0007\u0002)*\u0011QKV\u0001\u0006cV|G/\u0019\u0006\u0003/n\tq!\\1jY\n|\u00070\u0003\u0002Z)\na\u0011+^8uC6\u000bg.Y4fe\u0006i\u0011/^8uC6\u000bg.Y4fe\u0002\n\u0011#];pi\u0006\u0014vn\u001c;SKN|GN^3s+\u0005i\u0006CA*_\u0013\tyFKA\u000bVg\u0016\u0014\u0018+^8uCJ{w\u000e\u001e*fg>dg/\u001a:\u0002%E,x\u000e^1S_>$(+Z:pYZ,'\u000fI\u0001\u0007y%t\u0017\u000e\u001e \u0015\r\r$WMZ4i!\tQ\u0003\u0001C\u00034\u0017\u0001\u0007Q\u0007C\u0003?\u0017\u0001\u0007\u0001\tC\u0003H\u0017\u0001\u0007\u0011\nC\u0003Q\u0017\u0001\u0007!\u000bC\u0003\\\u0017\u0001\u0007Q\f\u000b\u0002\fUB\u00111\u000e]\u0007\u0002Y*\u0011QN\\\u0001\u0007S:TWm\u0019;\u000b\u0003=\fQA[1wCbL!!\u001d7\u0003\r%s'.Z2u\u0003)iW\r\u001e5pI:\u000bW.Z\u000b\u0002iB\u0011Q\u000f\u001f\b\u0003\u0015ZL!a^&\u0002\u0015%sgo\\2bi&|g.\u0003\u0002zu\nQQ*\u001a;i_\u0012t\u0015-\\3\u000b\u0005]\\\u0015aC7fi\"|GMT1nK\u0002\nAC]3rk&\u0014X\rZ\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001cX#\u0001@\u0011\u000b}\fi!a\u0005\u000f\t\u0005\u0005\u0011\u0011\u0002\t\u0004\u0003\u0007)SBAA\u0003\u0015\r\t9!I\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005-Q%\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003\u001f\t\tBA\u0002TKRT1!a\u0003&!\u0011\t)\"a\f\u000f\t\u0005]\u00111\u0006\b\u0005\u00033\tIC\u0004\u0003\u0002\u001c\u0005\u001db\u0002BA\u000f\u0003KqA!a\b\u0002$9!\u00111AA\u0011\u0013\u0005\u0001\u0013B\u0001\u0010 \u0013\taR$\u0003\u0002\u001b7%\u0011A*G\u0005\u0004\u0003[Y\u0015\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'/\u0003\u0003\u00022\u0005M\"\u0001F\"ba\u0006\u0014\u0017\u000e\\5us&#WM\u001c;jM&,'OC\u0002\u0002.-\u000bQC]3rk&\u0014X\rZ\"ba\u0006\u0014\u0017\u000e\\5uS\u0016\u001c\b%A\fk[\u0006\u0004\u0018+^8uC6\u000bg.Y4fe^\u0013\u0018\r\u001d9feV\u0011\u00111\b\t\u0004U\u0005u\u0012bAA /\t9\"*\\1q#V|G/Y'b]\u0006<WM],sCB\u0004XM]\u0001\u0019U6\f\u0007/U;pi\u0006l\u0015M\\1hKJ<&/\u00199qKJ\u0004\u0013!\u00033p!J|7-Z:t))\t9%!\u0017\u0002^\u0005\u0005\u0014Q\u000e\t\u0007\u0003\u0013\ny%a\u0015\u000e\u0005\u0005-#bAA'?\u0005y!/Z1di&4Xm\u001d;sK\u0006l7/\u0003\u0003\u0002R\u0005-#!\u0003)vE2L7\u000f[3s!\rQ\u0013QK\u0005\u0004\u0003/:\"!F%om>\u001c\u0017\r^5p]^KG\u000f[\"p]R,\u0007\u0010\u001e\u0005\u0007\u00037\u0012\u0002\u0019\u0001@\u0002\u0019\r\f\u0007/\u00192jY&$\u0018.Z:\t\u000f\u0005}#\u00031\u0001\u0002T\u0005Q\u0011N\u001c<pG\u0006$\u0018n\u001c8\t\u000f\u0005\r$\u00031\u0001\u0002f\u0005qQ.Y5mE>D8+Z:tS>t\u0007\u0003BA4\u0003Sj\u0011AV\u0005\u0004\u0003W2&AD'bS2\u0014w\u000e_*fgNLwN\u001c\u0005\u0007\u0003_\u0012\u0002\u0019A\u0017\u0002\u000fI,\u0017/^3ti\u0006Qq-\u001a;SKF,Xm\u001d;\u0015\r\u0005U\u0014QRAH!\u001d\t9(!!\u0002\b6rA!!\u001f\u0002~9!\u00111AA>\u0013\u00051\u0013bAA@K\u00059\u0001/Y2lC\u001e,\u0017\u0002BAB\u0003\u000b\u0013a!R5uQ\u0016\u0014(bAA@KA!\u0011qOAE\u0013\u0011\tY)!\"\u0003\u0013\u0015C8-\u001a9uS>t\u0007bBA2'\u0001\u0007\u0011Q\r\u0005\b\u0003?\u001a\u0002\u0019AAI!\rQ\u00151S\u0005\u0004\u0003+[%AC%om>\u001c\u0017\r^5p]\u0006q\u0001O]8dKN\u001c(+Z9vKN$HCCAN\u0003_\u000b\t,a-\u00026B1\u0011QTAV\u0003#k!!a(\u000b\t\u0005\u0005\u00161U\u0001\naV\u0014G.[:iKJT1AJAS\u0015\ra\u0015q\u0015\u0006\u0003\u0003S\u000bqA]3bGR|'/\u0003\u0003\u0002.\u0006}%!B*N_:|\u0007bBA2)\u0001\u0007\u0011Q\r\u0005\b\u0003?\"\u0002\u0019AAI\u0011\u0019\ty\u0007\u0006a\u0001[!1\u00111\f\u000bA\u0002y\fqBZ5mi\u0016\u0014\bK]3eS\u000e\fG/\u001a\u000b\u0005\u0003w\u000bi\rE\u0004%\u0003{\u000b\t-a2\n\u0007\u0005}VEA\u0005Gk:\u001cG/[8ocA\u0019a&a1\n\u0007\u0005\u0015wFA\u0005K[\u0006\u0004\u0018+^8uCB\u0019A%!3\n\u0007\u0005-WEA\u0004C_>dW-\u00198\t\u000f\u0005=W\u00031\u0001\u0002R\u00061a-\u001b7uKJ\u00042ALAj\u0013\r\t)n\f\u0002\u0011#V|G/Y)vKJLh)\u001b7uKJ\u0004")
public class QuotaQueryMethod
implements MethodRequiringAccountId<QuotaQueryRequest> {
    private final MetricFactory metricFactory;
    private final SessionSupplier sessionSupplier;
    private final SessionTranslator sessionTranslator;
    private final QuotaManager quotaManager;
    private final UserQuotaRootResolver quotaRootResolver;
    private final Invocation.MethodName methodName;
    private final scala.collection.immutable.Set<Refined<String, string.Uri>> requiredCapabilities;
    private final JmapQuotaManagerWrapper jmapQuotaManagerWrapper;
    private String JMAP_RFC8621_PREFIX;

    @Override
    public Publisher<InvocationWithContext> process(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession) {
        return MethodRequiringAccountId.process$(this, capabilities, invocation, mailboxSession);
    }

    @Override
    public String JMAP_RFC8621_PREFIX() {
        return this.JMAP_RFC8621_PREFIX;
    }

    @Override
    public void org$apache$james$jmap$method$Method$_setter_$JMAP_RFC8621_PREFIX_$eq(String x$1) {
        this.JMAP_RFC8621_PREFIX = x$1;
    }

    @Override
    public MetricFactory metricFactory() {
        return this.metricFactory;
    }

    @Override
    public SessionSupplier sessionSupplier() {
        return this.sessionSupplier;
    }

    @Override
    public SessionTranslator sessionTranslator() {
        return this.sessionTranslator;
    }

    public QuotaManager quotaManager() {
        return this.quotaManager;
    }

    public UserQuotaRootResolver quotaRootResolver() {
        return this.quotaRootResolver;
    }

    @Override
    public Invocation.MethodName methodName() {
        return this.methodName;
    }

    @Override
    public scala.collection.immutable.Set<Refined<String, string.Uri>> requiredCapabilities() {
        return this.requiredCapabilities;
    }

    public JmapQuotaManagerWrapper jmapQuotaManagerWrapper() {
        return this.jmapQuotaManagerWrapper;
    }

    @Override
    public Publisher<InvocationWithContext> doProcess(scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities, InvocationWithContext invocation, MailboxSession mailboxSession, QuotaQueryRequest request) {
        return this.processRequest(mailboxSession, invocation.invocation(), request, capabilities).onErrorResume((Function1 & Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof IllegalArgumentException) {
                IllegalArgumentException illegalArgumentException = (IllegalArgumentException)throwable;
                return SMono$.MODULE$.just((Object)Invocation$.MODULE$.error(ErrorCode$InvalidArguments$.MODULE$, illegalArgumentException.getMessage(), invocation.invocation().methodCallId()));
            }
            if (throwable != null) {
                Throwable throwable2 = throwable;
                return SMono$.MODULE$.error(throwable2);
            }
            throw new MatchError((Object)throwable);
        }).map((Function1 & Serializable)invocationResult -> new InvocationWithContext((Invocation)invocationResult, invocation.processingContext()));
    }

    @Override
    public Either<Exception, QuotaQueryRequest> getRequest(MailboxSession mailboxSession, Invocation invocation) {
        return QuotaSerializer$.MODULE$.deserializeQuotaQueryRequest((JsValue)invocation.arguments()).asEither().left().map((Function1 & Serializable)errors -> new IllegalArgumentException(ResponseSerializer$.MODULE$.serialize(new JsError(errors)).toString()));
    }

    private SMono<Invocation> processRequest(MailboxSession mailboxSession, Invocation invocation, QuotaQueryRequest request, scala.collection.immutable.Set<Refined<String, string.Uri>> capabilities) {
        return this.jmapQuotaManagerWrapper().list(mailboxSession.getUser(), capabilities).filter(this.filterPredicate(request.filter())).collectSeq().map((Function1 & Serializable)quotas -> new QuotaQueryResponse(request.accountId(), QueryState$.MODULE$.forQuotaIds((Seq<Refined<String, Id.IdConstraint>>)((Seq)((SeqOps)quotas.map((Function1 & Serializable)x$1 -> new Refined((Object)x$1.id()))).sortBy((Function1 & Serializable)x$2 -> (String)((Refined)x$2).value(), (Ordering)Ordering.String$.MODULE$))), false, (Seq)quotas.map((Function1 & Serializable)x$3 -> new Refined((Object)x$3.id())), Position$.MODULE$.zero(), (Option)new Some((Object)new Refined((Object)Limit$.MODULE$.default())))).map((Function1 & Serializable)response -> new Invocation(this.methodName(), QuotaSerializer$.MODULE$.serializeQuery((QuotaQueryResponse)response), invocation.methodCallId()));
    }

    private Function1<JmapQuota, Object> filterPredicate(QuotaQueryFilter filter) {
        return (Function1 & Serializable)quota -> BoxesRunTime.boxToBoolean((boolean)QuotaQueryMethod.$anonfun$filterPredicate$1(filter, quota));
    }

    public static final /* synthetic */ boolean $anonfun$filterPredicate$4(JmapQuota quota$1, scala.collection.immutable.Set dataTypesValue) {
        return quota$1.dataTypes().toSet().subsetOf((Set)dataTypesValue);
    }

    public static final /* synthetic */ boolean $anonfun$filterPredicate$1(QuotaQueryFilter filter$1, JmapQuota quota) {
        boolean bl;
        Option<QuotaName> option = filter$1.name();
        if (None$.MODULE$.equals(option)) {
            bl = true;
        } else if (option instanceof Some) {
            Some some = (Some)option;
            QuotaName value = (QuotaName)some.value();
            String string2 = value.string();
            String string3 = quota.name().string();
            bl = !(string2 != null ? !string2.equals(string3) : string3 != null);
        } else {
            throw new MatchError(option);
        }
        return bl && filter$1.scope().forall((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.contains((Object)quota.scope()))) && filter$1.resourceTypes().forall((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.contains((Object)quota.resourceType()))) && filter$1.dataTypes().forall((Function1 & Serializable)dataTypesValue -> BoxesRunTime.boxToBoolean((boolean)QuotaQueryMethod.$anonfun$filterPredicate$4(quota, dataTypesValue)));
    }

    @Inject
    public QuotaQueryMethod(MetricFactory metricFactory, SessionSupplier sessionSupplier, SessionTranslator sessionTranslator, QuotaManager quotaManager, UserQuotaRootResolver quotaRootResolver) {
        this.metricFactory = metricFactory;
        this.sessionSupplier = sessionSupplier;
        this.sessionTranslator = sessionTranslator;
        this.quotaManager = quotaManager;
        this.quotaRootResolver = quotaRootResolver;
        Method.$init$(this);
        MethodRequiringAccountId.$init$(this);
        this.methodName = new Invocation.MethodName((String)((Refined)RefType$.MODULE$.refinedRefType().unsafeWrap((Object)"Quota/query")).value());
        this.requiredCapabilities = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Refined[]{new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_QUOTA()), new Refined((Object)CapabilityIdentifier$.MODULE$.JMAP_CORE())}));
        this.jmapQuotaManagerWrapper = new JmapQuotaManagerWrapper(quotaManager, quotaRootResolver);
        Statics.releaseFence();
    }
}

