/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import com.google.inject.util.Modules;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Set;
import org.apache.james.CassandraRabbitMQJamesConfiguration;
import org.apache.james.ExtraProperties;
import org.apache.james.GuiceJamesServer;
import org.apache.james.JamesServerMain;
import org.apache.james.SearchConfiguration;
import org.apache.james.SearchModuleChooser;
import org.apache.james.data.UsersRepositoryModuleChooser;
import org.apache.james.jmap.draft.JMAPListenerModule;
import org.apache.james.json.DTO;
import org.apache.james.json.DTOModule;
import org.apache.james.modules.BlobExportMechanismModule;
import org.apache.james.modules.CassandraConsistencyTaskSerializationModule;
import org.apache.james.modules.DistributedTaskManagerModule;
import org.apache.james.modules.DistributedTaskSerializationModule;
import org.apache.james.modules.MailboxModule;
import org.apache.james.modules.MailetProcessingModule;
import org.apache.james.modules.RunArgumentsModule;
import org.apache.james.modules.TasksCleanupTaskSerializationModule;
import org.apache.james.modules.blobstore.BlobStoreCacheModulesChooser;
import org.apache.james.modules.blobstore.BlobStoreConfiguration;
import org.apache.james.modules.blobstore.BlobStoreModulesChooser;
import org.apache.james.modules.data.CassandraDLPConfigurationStoreModule;
import org.apache.james.modules.data.CassandraDelegationStoreModule;
import org.apache.james.modules.data.CassandraDomainListModule;
import org.apache.james.modules.data.CassandraJmapModule;
import org.apache.james.modules.data.CassandraRecipientRewriteTableModule;
import org.apache.james.modules.data.CassandraSieveRepositoryModule;
import org.apache.james.modules.data.CassandraUsersRepositoryModule;
import org.apache.james.modules.data.CassandraVacationModule;
import org.apache.james.modules.event.JMAPEventBusModule;
import org.apache.james.modules.event.RabbitMQEventBusModule;
import org.apache.james.modules.eventstore.CassandraEventStoreModule;
import org.apache.james.modules.mailbox.CassandraDeletedMessageVaultModule;
import org.apache.james.modules.mailbox.CassandraMailboxModule;
import org.apache.james.modules.mailbox.CassandraQuotaMailingModule;
import org.apache.james.modules.mailbox.CassandraSessionModule;
import org.apache.james.modules.mailbox.TikaMailboxModule;
import org.apache.james.modules.mailrepository.CassandraMailRepositoryModule;
import org.apache.james.modules.metrics.CassandraMetricsModule;
import org.apache.james.modules.protocols.IMAPServerModule;
import org.apache.james.modules.protocols.JMAPServerModule;
import org.apache.james.modules.protocols.JmapEventBusModule;
import org.apache.james.modules.protocols.LMTPServerModule;
import org.apache.james.modules.protocols.ManageSieveServerModule;
import org.apache.james.modules.protocols.POP3ServerModule;
import org.apache.james.modules.protocols.ProtocolHandlerModule;
import org.apache.james.modules.protocols.SMTPServerModule;
import org.apache.james.modules.queue.rabbitmq.MailQueueViewChoice;
import org.apache.james.modules.queue.rabbitmq.RabbitMQModule;
import org.apache.james.modules.server.DKIMMailetModule;
import org.apache.james.modules.server.DLPRoutesModule;
import org.apache.james.modules.server.DataRoutesModules;
import org.apache.james.modules.server.InconsistencyQuotasSolvingRoutesModule;
import org.apache.james.modules.server.JMXServerModule;
import org.apache.james.modules.server.JmapTasksModule;
import org.apache.james.modules.server.JmapUploadCleanupModule;
import org.apache.james.modules.server.MailQueueRoutesModule;
import org.apache.james.modules.server.MailRepositoriesRoutesModule;
import org.apache.james.modules.server.MailboxRoutesModule;
import org.apache.james.modules.server.MailboxesExportRoutesModule;
import org.apache.james.modules.server.MessagesRoutesModule;
import org.apache.james.modules.server.RabbitMailQueueRoutesModule;
import org.apache.james.modules.server.SieveRoutesModule;
import org.apache.james.modules.server.UserIdentityModule;
import org.apache.james.modules.server.VacationRoutesModule;
import org.apache.james.modules.server.WebAdminMailOverWebModule;
import org.apache.james.modules.server.WebAdminReIndexingTaskSerializationModule;
import org.apache.james.modules.server.WebAdminServerModule;
import org.apache.james.modules.vault.DeletedMessageVaultRoutesModule;
import org.apache.james.modules.webadmin.CassandraRoutesModule;
import org.apache.james.modules.webadmin.InconsistencySolvingRoutesModule;
import org.apache.james.modules.webadmin.TasksCleanupRoutesModule;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.vault.VaultConfiguration;

public class CassandraRabbitMQJamesServerMain
implements JamesServerMain {
    public static final Module WEBADMIN = Modules.combine((Module[])new Module[]{new CassandraRoutesModule(), new DataRoutesModules(), new VacationRoutesModule(), new DLPRoutesModule(), new InconsistencyQuotasSolvingRoutesModule(), new InconsistencySolvingRoutesModule(), new JmapUploadCleanupModule(), new UserIdentityModule(), new JmapTasksModule(), new MailboxesExportRoutesModule(), new MailboxRoutesModule(), new MailQueueRoutesModule(), new MailRepositoriesRoutesModule(), new SieveRoutesModule(), new TasksCleanupRoutesModule(), new WebAdminServerModule(), new WebAdminReIndexingTaskSerializationModule(), new MessagesRoutesModule(), new WebAdminMailOverWebModule()});
    public static final Module PROTOCOLS = Modules.combine((Module[])new Module[]{new CassandraJmapModule(), new CassandraVacationModule(), new IMAPServerModule(), new LMTPServerModule(), new ManageSieveServerModule(), new POP3ServerModule(), new ProtocolHandlerModule(), new SMTPServerModule(), new JMAPServerModule(), new JmapEventBusModule(), WEBADMIN});
    public static final Module PLUGINS = new CassandraQuotaMailingModule();
    private static final Module BLOB_MODULE = new BlobExportMechanismModule();
    private static final Module CASSANDRA_EVENT_STORE_JSON_SERIALIZATION_DEFAULT_MODULE = binder -> binder.bind(new TypeLiteral<Set<DTOModule<?, ? extends DTO>>>(){}).annotatedWith((Annotation)Names.named((String)"EventNestedTypes")).toInstance((Object)ImmutableSet.of());
    public static final Module CASSANDRA_SERVER_CORE_MODULE = Modules.combine((Module[])new Module[]{new CassandraDelegationStoreModule(), new CassandraDomainListModule(), new CassandraDLPConfigurationStoreModule(), new CassandraEventStoreModule(), new CassandraMailRepositoryModule(), new CassandraMetricsModule(), new CassandraRecipientRewriteTableModule(), new CassandraSessionModule(), new CassandraSieveRepositoryModule(), new TasksCleanupTaskSerializationModule(), BLOB_MODULE, CASSANDRA_EVENT_STORE_JSON_SERIALIZATION_DEFAULT_MODULE});
    public static final Module CASSANDRA_MAILBOX_MODULE = Modules.combine((Module[])new Module[]{new CassandraConsistencyTaskSerializationModule(), new CassandraMailboxModule(), new MailboxModule(), new TikaMailboxModule()});
    public static final Module REQUIRE_TASK_MANAGER_MODULE = Modules.combine((Module[])new Module[]{new MailetProcessingModule(), CASSANDRA_SERVER_CORE_MODULE, CASSANDRA_MAILBOX_MODULE, PROTOCOLS, PLUGINS, new DKIMMailetModule()});
    protected static final Module MODULES = Modules.override((Module[])new Module[]{REQUIRE_TASK_MANAGER_MODULE, new DistributedTaskManagerModule()}).with(new Module[]{new RabbitMQModule(), new RabbitMailQueueRoutesModule(), new JMAPEventBusModule(), new RabbitMQEventBusModule(), new DistributedTaskSerializationModule()});

    public static void main(String[] args) throws Exception {
        ExtraProperties.initialize();
        CassandraRabbitMQJamesConfiguration configuration = CassandraRabbitMQJamesConfiguration.builder().useWorkingDirectoryEnvProperty().build();
        LOGGER.info("Loading configuration {}", (Object)configuration.toString());
        GuiceJamesServer server = CassandraRabbitMQJamesServerMain.createServer(configuration).combineWith(new Module[]{new JMXServerModule()}).overrideWith(new Module[]{new RunArgumentsModule(args)});
        JamesServerMain.main((GuiceJamesServer)server);
    }

    public static GuiceJamesServer createServer(CassandraRabbitMQJamesConfiguration configuration) {
        BlobStoreConfiguration blobStoreConfiguration = configuration.blobStoreConfiguration();
        SearchConfiguration searchConfiguration = configuration.searchConfiguration();
        return GuiceJamesServer.forConfiguration((Configuration)configuration).combineWith(new Module[]{MODULES}).combineWith(new Module[]{MailQueueViewChoice.ModuleChooser.choose((MailQueueViewChoice)configuration.getMailQueueViewChoice())}).combineWith((Collection)BlobStoreModulesChooser.chooseModules((BlobStoreConfiguration)blobStoreConfiguration)).combineWith((Collection)BlobStoreCacheModulesChooser.chooseModules((BlobStoreConfiguration)blobStoreConfiguration)).combineWith((Collection)SearchModuleChooser.chooseModules((SearchConfiguration)searchConfiguration)).combineWith((Collection)new UsersRepositoryModuleChooser((Module)new CassandraUsersRepositoryModule()).chooseModules(configuration.getUsersRepositoryImplementation())).combineWith(new Module[]{CassandraRabbitMQJamesServerMain.chooseDeletedMessageVault(configuration.getVaultConfiguration())}).combineWith(new Module[]{CassandraRabbitMQJamesServerMain.chooseJmapModule(configuration)});
    }

    private static Module chooseDeletedMessageVault(VaultConfiguration vaultConfiguration) {
        if (vaultConfiguration.isEnabled()) {
            return Modules.combine((Module[])new Module[]{new CassandraDeletedMessageVaultModule(), new DeletedMessageVaultRoutesModule()});
        }
        return binder -> {};
    }

    private static Module chooseJmapModule(CassandraRabbitMQJamesConfiguration configuration) {
        if (configuration.isJmapEnabled()) {
            return new JMAPListenerModule();
        }
        return binder -> {};
    }
}

