/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.backends.cassandra.versions;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.james.backends.cassandra.versions.SchemaTransition;

public class SchemaVersion {
    private final int value;

    public SchemaVersion(int value) {
        Preconditions.checkArgument((value > 0 ? 1 : 0) != 0, (Object)"version needs to be strictly positive");
        this.value = value;
    }

    public int getValue() {
        return this.value;
    }

    public boolean isAfterOrEquals(SchemaVersion other) {
        return this.value >= other.value;
    }

    public SchemaVersion next() {
        return new SchemaVersion(this.value + 1);
    }

    public SchemaVersion previous() {
        return new SchemaVersion(this.value - 1);
    }

    public boolean isBefore(SchemaVersion other) {
        return this.value < other.value;
    }

    public List<SchemaTransition> listTransitionsForTarget(SchemaVersion target) {
        ArrayList<SchemaTransition> transitions = new ArrayList<SchemaTransition>();
        SchemaVersion migrateTo = this.next();
        while (target.isAfterOrEquals(migrateTo)) {
            SchemaTransition transition = SchemaTransition.to(migrateTo);
            transitions.add(transition);
            migrateTo = migrateTo.next();
        }
        return transitions;
    }

    public final boolean equals(Object o) {
        if (o instanceof SchemaVersion) {
            SchemaVersion that = (SchemaVersion)o;
            return Objects.equals(this.value, that.value);
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.value).toString();
    }
}

