/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.routes;

import com.google.common.base.Joiner;
import jakarta.inject.Inject;
import org.apache.james.core.Username;
import org.apache.james.core.quota.QuotaSizeLimit;
import org.apache.james.sieverepository.api.SieveQuotaRepository;
import org.apache.james.sieverepository.api.exception.QuotaNotFoundException;
import org.apache.james.user.api.UsersRepository;
import org.apache.james.user.api.UsersRepositoryException;
import org.apache.james.webadmin.Routes;
import org.apache.james.webadmin.utils.ErrorResponder;
import org.apache.james.webadmin.utils.JsonTransformer;
import org.apache.james.webadmin.utils.Responses;
import spark.Request;
import spark.Response;
import spark.ResponseTransformer;
import spark.Service;

public class SieveQuotaRoutes
implements Routes {
    public static final String ROOT_PATH = "/sieve/quota";
    public static final String DEFAULT_QUOTA_PATH = "/sieve/quota/default";
    private static final String USER_ID = "userId";
    private static final String USER_SIEVE_QUOTA_PATH = Joiner.on((String)"/").join((Object)"/sieve/quota", (Object)"users", new Object[]{":userId"});
    private final SieveQuotaRepository sieveQuotaRepository;
    private final UsersRepository usersRepository;
    private final JsonTransformer jsonTransformer;

    @Inject
    public SieveQuotaRoutes(SieveQuotaRepository sieveQuotaRepository, UsersRepository usersRepository, JsonTransformer jsonTransformer) {
        this.sieveQuotaRepository = sieveQuotaRepository;
        this.usersRepository = usersRepository;
        this.jsonTransformer = jsonTransformer;
    }

    public String getBasePath() {
        return ROOT_PATH;
    }

    public void define(Service service) {
        this.defineGetGlobalSieveQuota(service);
        this.defineUpdateGlobalSieveQuota(service);
        this.defineRemoveGlobalSieveQuota(service);
        this.defineGetPerUserSieveQuota(service);
        this.defineUpdatePerUserSieveQuota(service);
        this.defineRemovePerUserSieveQuota(service);
    }

    public void defineGetGlobalSieveQuota(Service service) {
        service.get(DEFAULT_QUOTA_PATH, (request, response) -> {
            try {
                QuotaSizeLimit sieveQuota = this.sieveQuotaRepository.getDefaultQuota();
                response.status(200);
                return sieveQuota.asLong();
            }
            catch (QuotaNotFoundException e) {
                return Responses.returnNoContent((Response)response);
            }
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineUpdateGlobalSieveQuota(Service service) {
        service.put(DEFAULT_QUOTA_PATH, (request, response) -> {
            QuotaSizeLimit requestedSize = this.extractRequestedQuotaSizeFromRequest(request);
            this.sieveQuotaRepository.setDefaultQuota(requestedSize);
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineRemoveGlobalSieveQuota(Service service) {
        service.delete(DEFAULT_QUOTA_PATH, (request, response) -> {
            try {
                this.sieveQuotaRepository.removeQuota();
            }
            catch (QuotaNotFoundException quotaNotFoundException) {
                // empty catch block
            }
            return Responses.returnNoContent((Response)response);
        });
    }

    public void defineGetPerUserSieveQuota(Service service) {
        service.get(USER_SIEVE_QUOTA_PATH, (request, response) -> {
            Username userId = this.getUsername(request.params(USER_ID));
            try {
                QuotaSizeLimit userQuota = this.sieveQuotaRepository.getQuota(userId);
                response.status(200);
                return userQuota.asLong();
            }
            catch (QuotaNotFoundException e) {
                return Responses.returnNoContent((Response)response);
            }
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineUpdatePerUserSieveQuota(Service service) {
        service.put(USER_SIEVE_QUOTA_PATH, (request, response) -> {
            Username userId = this.getUsername(request.params(USER_ID));
            QuotaSizeLimit requestedSize = this.extractRequestedQuotaSizeFromRequest(request);
            this.sieveQuotaRepository.setQuota(userId, requestedSize);
            return Responses.returnNoContent((Response)response);
        }, (ResponseTransformer)this.jsonTransformer);
    }

    public void defineRemovePerUserSieveQuota(Service service) {
        service.delete(USER_SIEVE_QUOTA_PATH, (request, response) -> {
            Username usernameId = this.getUsername(request.params(USER_ID));
            try {
                this.sieveQuotaRepository.removeQuota(usernameId);
            }
            catch (QuotaNotFoundException quotaNotFoundException) {
                // empty catch block
            }
            return Responses.returnNoContent((Response)response);
        });
    }

    private QuotaSizeLimit extractRequestedQuotaSizeFromRequest(Request request) {
        long requestedSize = this.extractNumberFromRequestBody(request);
        if (requestedSize < 0L) {
            throw ErrorResponder.builder().type(ErrorResponder.ErrorType.INVALID_ARGUMENT).statusCode(400).message("Requested quota size have to be a positive integer").haltError();
        }
        return QuotaSizeLimit.size((long)requestedSize);
    }

    private long extractNumberFromRequestBody(Request request) {
        String body = request.body();
        try {
            return Long.parseLong(body);
        }
        catch (NumberFormatException e) {
            throw ErrorResponder.builder().type(ErrorResponder.ErrorType.INVALID_ARGUMENT).statusCode(400).message("unrecognized integer number '%s'", new Object[]{body}).haltError();
        }
    }

    private Username getUsername(String usernameParameter) throws UsersRepositoryException {
        Username username = Username.of((String)usernameParameter);
        if (!this.usersRepository.contains(username)) {
            throw ErrorResponder.builder().statusCode(404).type(ErrorResponder.ErrorType.INVALID_ARGUMENT).message("User %s does not exist", new Object[]{username}).haltError();
        }
        return username;
    }
}

