/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.controller;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.Attribute;
import org.apache.logging.log4j.catalog.api.Constraint;
import org.apache.logging.log4j.catalog.api.ListResponse;
import org.apache.logging.log4j.catalog.api.plugins.ConstraintPlugins;
import org.apache.logging.log4j.catalog.jpa.converter.AttributeConverter;
import org.apache.logging.log4j.catalog.jpa.converter.AttributeModelConverter;
import org.apache.logging.log4j.catalog.jpa.model.AttributeModel;
import org.apache.logging.log4j.catalog.jpa.model.ConstraintModel;
import org.apache.logging.log4j.catalog.jpa.service.AttributeService;
import org.modelmapper.Converter;
import org.modelmapper.ModelMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/attributes"})
@RestController
public class AttributeController {
    private static final Logger LOGGER = LogManager.getLogger();
    private static ConstraintPlugins constraintPlugins = ConstraintPlugins.getInstance();
    private ModelMapper modelMapper = new ModelMapper();
    @Autowired
    private AttributeService attributeService;
    @Autowired
    private AttributeModelConverter attributeModelConverter;
    @Autowired
    private AttributeConverter attributeConverter;

    @PostConstruct
    public void init() {
        this.modelMapper.addConverter((Converter)this.attributeModelConverter);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<Map<String, Object>> attributeList(@RequestParam(value="jtStartIndex", required=false) Integer startIndex, @RequestParam(value="jtPageSize", required=false) Integer pageSize, @RequestParam(value="jtSorting", required=false) String sorting) {
        Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            List attributes = null;
            if (startIndex == null || pageSize == null) {
                attributes = (ArrayList)this.modelMapper.map((Object)this.attributeService.getAttributes(), listType);
            } else {
                int startPage = 0;
                if (startIndex > 0) {
                    startPage = startIndex / pageSize;
                }
                String sortColumn = "name";
                String sortDirection = "ASC";
                if (sorting != null) {
                    String[] sortInfo = sorting.split(" ");
                    sortColumn = sortInfo[0];
                    if (sortInfo.length > 0) {
                        sortDirection = sortInfo[1];
                    }
                }
                attributes = (List)this.modelMapper.map((Object)this.attributeService.getAttributes(startPage, pageSize.intValue(), sortColumn, sortDirection), listType);
            }
            if (attributes == null) {
                attributes = new ArrayList();
            }
            response.put("Result", "OK");
            response.put("Records", attributes);
        }
        catch (Exception ex) {
            response.put("Result", "FAILURE");
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<Map<String, Object>> createAttribute(@RequestBody Attribute attribute) {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            AttributeModel model = this.attributeConverter.convert(attribute);
            model = this.attributeService.saveAttribute(model);
            Attribute result = this.attributeModelConverter.convert(model);
            response.put("Result", "OK");
            response.put("Records", (String)result);
        }
        catch (Exception ex) {
            response.put("Result", "FAILURE");
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<Map<String, Object>> updateAttribute(@RequestBody Attribute attribute) {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            AttributeModel model = this.attributeConverter.convert(attribute);
            model = this.attributeService.saveAttribute(model);
            Attribute result = this.attributeModelConverter.convert(model);
            response.put("Result", "OK");
            response.put("Records", (String)result);
        }
        catch (Exception ex) {
            response.put("Result", "FAILURE");
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<Map<String, Object>> deleteAttribute(@RequestBody Attribute attribute) {
        HashMap<String, String> response = new HashMap<String, String>();
        try {
            this.attributeService.deleteAttribute(attribute.getId());
            response.put("Result", "OK");
        }
        catch (Exception ex) {
            response.put("Result", "FAILURE");
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }

    @GetMapping
    public ResponseEntity<ListResponse<String>> getAttributeNames() {
        ArrayList<String> attributeNames;
        List attributes = this.attributeService.getAttributes();
        if (attributes != null) {
            attributeNames = new ArrayList(attributes.size());
            for (AttributeModel model : attributes) {
                attributeNames.add(model.getName());
            }
        } else {
            attributeNames = new ArrayList<String>();
        }
        ListResponse response = new ListResponse();
        response.setResult("OK");
        response.setData(attributeNames);
        return new ResponseEntity((Object)response, HttpStatus.OK);
    }

    @PostMapping(value={"/constraints"})
    public ResponseEntity<Map<String, Object>> constraintList(@RequestParam(value="attributeId") Long attributeId) {
        Type listType = new /* Unavailable Anonymous Inner Class!! */.getType();
        HashMap<String, Object> response = new HashMap<String, Object>();
        try {
            Optional optional = this.attributeService.getAttribute(attributeId);
            ArrayList<Constraint> constraints = new ArrayList<Constraint>();
            if (optional.isPresent()) {
                Set constraintModels = ((AttributeModel)optional.get()).getConstraints();
                if (constraintModels != null) {
                    for (ConstraintModel constraintModel : constraintModels) {
                        Constraint constraint = new Constraint();
                        constraint.setConstraintType(constraintPlugins.findByName(constraintModel.getConstraintType()));
                        constraint.setValue(constraintModel.getValue());
                        constraints.add(constraint);
                    }
                }
                response.put("Result", "OK");
                response.put("Records", constraints);
            }
        }
        catch (Exception ex) {
            response.put("Result", "FAILURE");
        }
        return new ResponseEntity(response, HttpStatus.OK);
    }
}

