/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.jpa.converter;

import java.util.ArrayList;
import org.apache.logging.log4j.catalog.api.Product;
import org.apache.logging.log4j.catalog.jpa.model.EventModel;
import org.apache.logging.log4j.catalog.jpa.model.ProductModel;
import org.apache.logging.log4j.catalog.jpa.service.EventService;
import org.modelmapper.AbstractConverter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProductModelConverter
extends AbstractConverter<ProductModel, Product> {
    @Autowired
    private EventService eventService;

    public Product convert(ProductModel productModel) {
        Product product = new Product();
        product.setId(productModel.getId());
        product.setName(productModel.getName());
        product.setDisplayName(productModel.getDisplayName());
        product.setDescription(productModel.getDescription());
        product.setCatalogId(productModel.getCatalogId());
        ArrayList<String> events = new ArrayList<String>(productModel.getEvents().size());
        for (EventModel event : productModel.getEvents()) {
            events.add(event.getName());
        }
        product.setEvents(events);
        return product;
    }
}

