/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api.plugins;

import java.math.BigDecimal;
import org.apache.logging.log4j.catalog.api.ConstraintType;
import org.apache.logging.log4j.catalog.api.util.StringUtils;
import org.apache.logging.log4j.core.config.plugins.Plugin;

@Plugin(name="maxValue", category="Constraint")
public class MaxValueConstraint
implements ConstraintType {
    @Override
    public void validate(boolean isRequestContext, String name, String value, String maxValue, StringBuilder error) {
        if (StringUtils.isBlank(maxValue)) {
            StringUtils.appendNewline(error);
            if (isRequestContext) {
                error.append("ThreadContext key ");
            }
            error.append(name).append(" has no value for the minimum value defined");
            return;
        }
        if (!StringUtils.isBlank(value)) {
            try {
                BigDecimal minVal = new BigDecimal(maxValue);
                BigDecimal val = new BigDecimal(value);
                if (val.compareTo(minVal) > 0) {
                    StringUtils.appendNewline(error);
                    if (isRequestContext) {
                        error.append("ThreadContext key ");
                    }
                    error.append(name).append(" is less than ").append(maxValue);
                }
            }
            catch (Exception ex) {
                StringUtils.appendNewline(error);
                if (isRequestContext) {
                    error.append("ThreadContext key ");
                }
                error.append(name).append(" encountered an error trying to determine the minimum value: ").append(ex.getMessage());
            }
        }
    }
}

