/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.changelog;

import java.nio.file.Path;
import org.apache.logging.log4j.changelog.util.XmlReader;
import org.apache.logging.log4j.changelog.util.XmlWriter;
import org.w3c.dom.Element;

public final class ChangelogRelease {
    public final String version;
    public final String date;

    public ChangelogRelease(String version, String date) {
        this.version = version;
        this.date = date;
    }

    public void writeToXmlFile(Path path) {
        XmlWriter.toFile(path, "release", (document, releaseElement) -> {
            releaseElement.setAttribute("version", this.version);
            releaseElement.setAttribute("date", this.date);
        });
    }

    public static ChangelogRelease readFromXmlFile(Path path) {
        Element releaseElement = XmlReader.readXmlFileRootElement(path, "release");
        String version = XmlReader.requireAttribute(releaseElement, "version");
        String date = XmlReader.requireAttribute(releaseElement, "date");
        return new ChangelogRelease(version, date);
    }
}

