/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.weaver;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.lang.invoke.CallSite;
import java.lang.invoke.LambdaMetafactory;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.Map;
import org.apache.logging.log4j.weaver.ClassConversionHandler;
import org.apache.logging.log4j.weaver.Constants;
import org.apache.logging.log4j.weaver.LocationCacheGenerator;
import org.apache.logging.log4j.weaver.LocationClassVisitor;
import org.apache.logging.log4j.weaver.SupplierLambdaType;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;

public class LocationMethodVisitor
extends GeneratorAdapter {
    private static Type SUPPLIER_OF_OBJECT_TYPE = Type.getMethodType((Type)Constants.OBJECT_TYPE, (Type[])new Type[0]);
    private static Type SUPPLIER_OF_MESSAGE_TYPE = Type.getMethodType((Type)Constants.MESSAGE_TYPE, (Type[])new Type[0]);
    private static final Type LAMBDA_METAFACTORY_TYPE = Type.getType(LambdaMetafactory.class);
    private static final Type METHOD_HANDLE_TYPE = Type.getType(MethodHandle.class);
    private static final Type METHOD_TYPE_TYPE = Type.getType(MethodType.class);
    private static final String LAMBDA_METAFACTORY_DESC = Type.getMethodDescriptor((Type)Type.getType(CallSite.class), (Type[])new Type[]{Type.getType(MethodHandles.Lookup.class), Constants.STRING_TYPE, METHOD_TYPE_TYPE, METHOD_TYPE_TYPE, METHOD_HANDLE_TYPE, METHOD_TYPE_TYPE});
    private static final Handle LAMBDA_METAFACTORY_HANDLE = new Handle(6, LAMBDA_METAFACTORY_TYPE.getInternalName(), "metafactory", LAMBDA_METAFACTORY_DESC, false);
    private final LocationClassVisitor locationClassVisitor;
    private final Map<String, ClassConversionHandler> handlers;
    private final Integer[] localVariables = new Integer[12];
    private final Label[] startLabels = new Label[12];
    private int nextVariable = 0;
    private int lineNumber;
    private Label currentLabel;

    protected LocationMethodVisitor(LocationClassVisitor locationClassVisitor, Map<String, ClassConversionHandler> handlers, MethodVisitor mv, int access, String name, String descriptor) {
        super(589824, mv, access, name, descriptor);
        this.locationClassVisitor = locationClassVisitor;
        this.handlers = handlers;
    }

    public void visitLineNumber(int line, Label start) {
        this.lineNumber = line;
        super.visitLineNumber(line, start);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        this.resetLocals();
        ClassConversionHandler handler = this.handlers.get(owner);
        if (handler != null) {
            handler.handleMethodInstruction(this, name, descriptor);
        } else {
            super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        }
    }

    public void storeLocation() {
        LocationCacheGenerator.LocationCacheValue location = this.locationClassVisitor.addStackTraceElement(this.lineNumber);
        this.getStatic(location.getType(), location.getFieldName(), Constants.STACK_TRACE_ELEMENT_ARRAY_TYPE);
        this.push(location.getIndex());
        this.arrayLoad(Constants.STACK_TRACE_ELEMENT_TYPE);
        this.invokeInterface(Constants.LOG_BUILDER_TYPE, Constants.WITH_LOCATION_METHOD);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public void visitLabel(Label label) {
        this.currentLabel = label;
        super.visitLabel(label);
    }

    public void visitEnd() {
        for (int i = 0; i < this.startLabels.length; ++i) {
            Label label = this.startLabels[i];
            if (label == null) continue;
            this.mv.visitLocalVariable("log4j2$$p" + i, Constants.OBJECT_TYPE.getDescriptor(), null, label, this.currentLabel, this.localVariables[i].intValue());
        }
        super.visitEnd();
    }

    private void resetLocals() {
        this.nextVariable = 0;
    }

    public int nextLocal() {
        Integer varIndex = this.localVariables[this.nextVariable];
        if (varIndex == null) {
            this.localVariables[this.nextVariable] = varIndex = Integer.valueOf(this.newLocal(Constants.OBJECT_TYPE));
            this.startLabels[this.nextVariable] = this.currentLabel;
        }
        ++this.nextVariable;
        return varIndex;
    }

    public void invokeSupplierLambda(SupplierLambdaType type) {
        this.invokeDynamic("get", type.getInvokedMethodDescriptor(), LAMBDA_METAFACTORY_HANDLE, new Object[]{SUPPLIER_OF_OBJECT_TYPE, this.locationClassVisitor.createLambda(type), SUPPLIER_OF_MESSAGE_TYPE});
    }
}

