/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.weaver.log4j2;

import java.util.Arrays;
import org.apache.logging.log4j.weaver.ClassConversionHandler;
import org.apache.logging.log4j.weaver.Constants;
import org.apache.logging.log4j.weaver.ConversionException;
import org.apache.logging.log4j.weaver.LocationMethodVisitor;
import org.apache.logging.log4j.weaver.SupplierLambdaType;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

public class LoggerConversionHandler
implements ClassConversionHandler {
    private static final String CATCHING = "Catching";
    private static final String CATCHING_MARKER = "CATCHING_MARKER";
    private static final String ENTRY_MARKER = "ENTRY_MARKER";
    private static final String EXIT_MARKER = "EXIT_MARKER";
    private static final String THROWING = "Throwing";
    private static final String THROWING_MARKER = "THROWING_MARKER";
    private static final Type[] LOG_BUILDER_LOG_STRING_SUPPLIER = new Type[]{Constants.STRING_TYPE, Constants.SUPPLIER_ARRAY_TYPE};
    private static final Type[] LOG_BUILDER_LOG_SUPPLIER_MESSAGE = new Type[]{Constants.SUPPLIER_TYPE};
    private static final Method LOG_BUILDER_LOG_SUPPLIER_METHOD = new Method("log", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])LOG_BUILDER_LOG_SUPPLIER_MESSAGE));
    private static final Method LOG_BUILDER_LOG_STRING_METHOD = new Method("log", Type.getMethodDescriptor((Type)Type.VOID_TYPE, (Type[])new Type[]{Constants.STRING_TYPE}));
    private static final Type ABSTRACT_LOGGER_TYPE = Type.getObjectType((String)"org/apache/logging/log4j/spi/AbstractLogger");
    private static final Type[] MESSAGE_OBJECT_ARRAY = new Type[]{Constants.MESSAGE_TYPE, Constants.OBJECT_TYPE};

    @Override
    public String getOwner() {
        return Constants.LOGGER_TYPE.getInternalName();
    }

    private void createLogBuilder(LocationMethodVisitor mv, String methodName) {
        Method method;
        switch (methodName) {
            case "debug": {
                method = Constants.AT_DEBUG_METHOD;
                break;
            }
            case "error": {
                method = Constants.AT_ERROR_METHOD;
                break;
            }
            case "fatal": {
                method = Constants.AT_FATAL_METHOD;
                break;
            }
            case "info": {
                method = Constants.AT_INFO_METHOD;
                break;
            }
            case "log": {
                method = Constants.AT_LEVEL_METHOD;
                break;
            }
            case "trace": {
                method = Constants.AT_TRACE_METHOD;
                break;
            }
            case "warn": {
                method = Constants.AT_WARN_METHOD;
                break;
            }
            default: {
                throw new ConversionException("Unknown logging method " + methodName);
            }
        }
        mv.invokeInterface(Constants.LOGGER_TYPE, method);
    }

    @Override
    public void handleMethodInstruction(LocationMethodVisitor mv, String name, String descriptor) {
        switch (name) {
            case "debug": 
            case "error": 
            case "fatal": 
            case "info": 
            case "log": 
            case "trace": 
            case "warn": {
                this.handleLogMethods(mv, name, descriptor);
                break;
            }
            case "printf": {
                this.handlePrintfMethods(mv, descriptor);
                break;
            }
            case "always": 
            case "atDebug": 
            case "atError": 
            case "atFatal": 
            case "atInfo": 
            case "atLevel": 
            case "atTrace": 
            case "atWarn": {
                mv.invokeInterface(Constants.LOGGER_TYPE, new Method(name, descriptor));
                mv.storeLocation();
                break;
            }
            case "catching": 
            case "throwing": {
                this.handleCatchingThrowing(mv, descriptor, "throwing".equals(name));
                break;
            }
            case "isDebugEnabled": 
            case "isEnabled": 
            case "isErrorEnabled": 
            case "isFatalEnabled": 
            case "isInfoEnabled": 
            case "isTraceEnabled": 
            case "isWarnEnabled": 
            case "logMessage": {
                mv.invokeInterface(Constants.LOGGER_TYPE, new Method(name, descriptor));
                break;
            }
            case "traceEntry": {
                this.handleTraceEntry(mv, descriptor);
                break;
            }
            case "traceExit": {
                this.handleTraceExit(mv, descriptor);
                break;
            }
            default: {
                throw new ConversionException("Unsupported method 'org.apache.logging.log4j.Logger#" + name + "'.");
            }
        }
    }

    private void handleLogMethods(LocationMethodVisitor mv, String name, String descriptor) {
        Type[] arguments;
        Type[] types = Type.getArgumentTypes((String)descriptor);
        int[] varIndexes = new int[types.length];
        int from = types.length > 0 && types[0].equals((Object)Constants.LEVEL_TYPE) ? 1 : 0;
        int to = types.length;
        for (int i = to - 1; i >= from; --i) {
            varIndexes[i] = mv.nextLocal();
            mv.storeLocal(varIndexes[i], types[i]);
        }
        this.createLogBuilder(mv, name);
        mv.storeLocation();
        if (from < to && types[from].equals((Object)Constants.MARKER_TYPE)) {
            mv.loadLocal(varIndexes[from], Constants.MARKER_TYPE);
            mv.invokeInterface(Constants.LOG_BUILDER_TYPE, Constants.WITH_MARKER_METHOD);
            ++from;
        }
        if (from < to && types[to - 1].equals((Object)Constants.THROWABLE_TYPE)) {
            mv.loadLocal(varIndexes[to - 1], Constants.THROWABLE_TYPE);
            mv.invokeInterface(Constants.LOG_BUILDER_TYPE, Constants.WITH_THROWABLE_METHOD);
            --to;
        }
        if (Constants.SUPPLIER_TYPE.equals((Object)types[from])) {
            mv.push("{}");
            mv.push(1);
            mv.newArray(Constants.SUPPLIER_TYPE);
            mv.dup();
            mv.push(0);
            mv.loadLocal(varIndexes[from], types[from]);
            mv.arrayStore(Constants.SUPPLIER_TYPE);
            arguments = LOG_BUILDER_LOG_STRING_SUPPLIER;
        } else if (Constants.MESSAGE_SUPPLIER_TYPE.equals((Object)types[from])) {
            mv.loadLocal(varIndexes[from], types[from]);
            mv.invokeSupplierLambda(SupplierLambdaType.MESSAGE_SUPPLIER);
            arguments = LOG_BUILDER_LOG_SUPPLIER_MESSAGE;
        } else {
            for (int i = from; i < to; ++i) {
                mv.loadLocal(varIndexes[i], types[i]);
            }
            arguments = Arrays.copyOfRange(types, from, to);
        }
        Method logMethod = new Method("log", Type.VOID_TYPE, arguments);
        mv.invokeInterface(Constants.LOG_BUILDER_TYPE, logMethod);
    }

    private void handlePrintfMethods(LocationMethodVisitor mv, String descriptor) {
        Type[] types = Type.getArgumentTypes((String)descriptor);
        mv.invokeSupplierLambda(SupplierLambdaType.FORMATTED_MESSAGE);
        int supplierIndex = mv.nextLocal();
        mv.storeLocal(supplierIndex, Constants.SUPPLIER_TYPE);
        int markerIndex = -1;
        if (types[1].equals((Object)Constants.MARKER_TYPE)) {
            markerIndex = mv.nextLocal();
            mv.storeLocal(markerIndex, Constants.MARKER_TYPE);
        }
        mv.invokeInterface(Constants.LOGGER_TYPE, Constants.AT_LEVEL_METHOD);
        mv.storeLocation();
        if (markerIndex >= 0) {
            mv.loadLocal(markerIndex, Constants.MARKER_TYPE);
            mv.invokeInterface(Constants.LOG_BUILDER_TYPE, Constants.WITH_MARKER_METHOD);
        }
        mv.loadLocal(supplierIndex, Constants.SUPPLIER_TYPE);
        mv.invokeInterface(Constants.LOG_BUILDER_TYPE, LOG_BUILDER_LOG_SUPPLIER_METHOD);
    }

    private void handleCatchingThrowing(LocationMethodVisitor mv, String descriptor, boolean throwing) {
        boolean hasLevel = Type.getArgumentTypes((String)descriptor).length > 1;
        int throwableIndex = mv.nextLocal();
        mv.storeLocal(throwableIndex, Constants.THROWABLE_TYPE);
        if (hasLevel) {
            mv.invokeInterface(Constants.LOGGER_TYPE, Constants.AT_LEVEL_METHOD);
        } else {
            mv.invokeInterface(Constants.LOGGER_TYPE, Constants.AT_ERROR_METHOD);
        }
        mv.storeLocation();
        mv.loadLocal(throwableIndex, Constants.THROWABLE_TYPE);
        mv.invokeInterface(Constants.LOG_BUILDER_TYPE, Constants.WITH_THROWABLE_METHOD);
        mv.getStatic(ABSTRACT_LOGGER_TYPE, throwing ? THROWING_MARKER : CATCHING_MARKER, Constants.MARKER_TYPE);
        mv.invokeInterface(Constants.LOG_BUILDER_TYPE, Constants.WITH_MARKER_METHOD);
        mv.push(throwing ? THROWING : CATCHING);
        mv.invokeInterface(Constants.LOG_BUILDER_TYPE, LOG_BUILDER_LOG_STRING_METHOD);
        if (throwing) {
            mv.loadLocal(throwableIndex, Constants.THROWABLE_TYPE);
        }
    }

    private void handleTraceEntry(LocationMethodVisitor mv, String descriptor) {
        Type[] types = Type.getArgumentTypes((String)descriptor);
        int[] vars = new int[types.length];
        for (int i = vars.length - 1; i >= 0; --i) {
            vars[i] = mv.nextLocal();
            mv.storeLocal(vars[i]);
        }
        mv.dup();
        int loggerIdx = mv.nextLocal();
        mv.storeLocal(loggerIdx, Constants.LOGGER_TYPE);
        mv.invokeInterface(Constants.LOGGER_TYPE, Constants.AT_TRACE_METHOD);
        mv.storeLocation();
        mv.getStatic(ABSTRACT_LOGGER_TYPE, ENTRY_MARKER, Constants.MARKER_TYPE);
        mv.invokeInterface(Constants.LOG_BUILDER_TYPE, Constants.WITH_MARKER_METHOD);
        mv.loadLocal(loggerIdx, Constants.LOGGER_TYPE);
        if (types.length == 0) {
            mv.push(null);
            mv.push(null);
            mv.invokeSupplierLambda(SupplierLambdaType.ENTRY_MESSAGE_STRING_OBJECTS);
        } else if (types[0].equals((Object)Constants.MESSAGE_TYPE)) {
            mv.loadLocal(vars[0]);
            mv.invokeSupplierLambda(SupplierLambdaType.ENTRY_MESSAGE_MESSAGE);
        } else {
            if (types.length == 1) {
                mv.push(null);
            }
            for (int i = 0; i < vars.length; ++i) {
                mv.loadLocal(vars[i]);
            }
            boolean usesSuppliers = types[types.length - 1].equals((Object)Constants.SUPPLIER_ARRAY_TYPE);
            mv.invokeSupplierLambda(usesSuppliers ? SupplierLambdaType.ENTRY_MESSAGE_STRING_SUPPLIERS : SupplierLambdaType.ENTRY_MESSAGE_STRING_OBJECTS);
        }
        mv.invokeInterface(Constants.LOG_BUILDER_TYPE, Constants.LOG_AND_GET_METHOD);
    }

    private void handleTraceExit(LocationMethodVisitor mv, String descriptor) {
        Object[] types = Type.getArgumentTypes((String)descriptor);
        int[] vars = new int[types.length];
        for (int i = vars.length - 1; i >= 0; --i) {
            vars[i] = mv.nextLocal();
            mv.storeLocal(vars[i]);
        }
        mv.dup();
        int loggerIdx = mv.nextLocal();
        mv.storeLocal(loggerIdx, Constants.LOGGER_TYPE);
        mv.invokeInterface(Constants.LOGGER_TYPE, Constants.AT_TRACE_METHOD);
        mv.storeLocation();
        mv.getStatic(ABSTRACT_LOGGER_TYPE, EXIT_MARKER, Constants.MARKER_TYPE);
        mv.invokeInterface(Constants.LOG_BUILDER_TYPE, Constants.WITH_MARKER_METHOD);
        mv.loadLocal(loggerIdx, Constants.LOGGER_TYPE);
        if (types.length == 0) {
            mv.push(null);
            mv.push(null);
            mv.invokeSupplierLambda(SupplierLambdaType.EXIT_MESSAGE_STRING_OBJECT);
        } else if (Arrays.deepEquals(types, MESSAGE_OBJECT_ARRAY)) {
            mv.loadLocal(vars[1]);
            mv.loadLocal(vars[0]);
            mv.invokeSupplierLambda(SupplierLambdaType.EXIT_MESSAGE_OBJECT_MESSAGE);
        } else if (Constants.ENTRY_MESSAGE_TYPE.equals(types[0])) {
            boolean hasResult;
            boolean bl = hasResult = types.length == 2;
            if (hasResult) {
                mv.loadLocal(vars[1]);
            }
            mv.loadLocal(vars[0]);
            mv.invokeSupplierLambda(hasResult ? SupplierLambdaType.EXIT_MESSAGE_OBJECT_ENTRY_MESSAGE : SupplierLambdaType.EXIT_MESSAGE_ENTRY_MESSAGE);
        } else {
            boolean hasFormat = Constants.STRING_TYPE.equals(types[0]);
            if (hasFormat) {
                mv.loadLocal(vars[0]);
            } else {
                mv.push(null);
            }
            mv.loadLocal(vars[hasFormat ? 1 : 0], Constants.OBJECT_TYPE);
            mv.invokeSupplierLambda(SupplierLambdaType.EXIT_MESSAGE_STRING_OBJECT);
        }
        mv.invokeInterface(Constants.LOG_BUILDER_TYPE, LOG_BUILDER_LOG_SUPPLIER_METHOD);
        if (!(types.length == 0 || types.length <= 1 && Constants.ENTRY_MESSAGE_TYPE.equals(types[0]))) {
            mv.loadLocal(vars[vars.length - 1]);
        }
    }
}

