/*
 * Decompiled with CFR 0.152.
 */
package org.apache.chemistry.opencmis.inmemory.types;

import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.chemistry.opencmis.commons.definitions.DocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.FolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.ItemTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableDocumentTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableFolderTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableItemTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutablePolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutablePropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableRelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableSecondaryTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.MutableTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PolicyTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.RelationshipTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.SecondaryTypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeMutability;
import org.apache.chemistry.opencmis.commons.enums.CmisVersion;
import org.apache.chemistry.opencmis.commons.enums.ContentStreamAllowed;
import org.apache.chemistry.opencmis.commons.enums.Updatability;
import org.apache.chemistry.opencmis.commons.exceptions.CmisInvalidArgumentException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.DocumentTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.FolderTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.ItemTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PolicyTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.RelationshipTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.SecondaryTypeDefinitionImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.TypeMutabilityImpl;
import org.apache.chemistry.opencmis.inmemory.types.PropertyCreationHelper;
import org.apache.chemistry.opencmis.server.support.TypeDefinitionFactory;

public final class DocumentTypeCreationHelper {
    private static final List<TypeDefinition> DEFAULT_TYPES = DocumentTypeCreationHelper.createCmisDefaultTypes();
    private static TypeDefinitionFactory typeFactory;
    private static MutableDocumentTypeDefinition cmisTypeDoc;
    private static MutableFolderTypeDefinition cmisTypeFolder;
    private static MutableRelationshipTypeDefinition cmisTypeRel;
    private static MutablePolicyTypeDefinition cmisTypePolicy;
    private static MutableItemTypeDefinition cmisTypeItem;
    private static MutableSecondaryTypeDefinition cmisTypeSecondary;

    public static DocumentTypeDefinition getCmisDocumentType() {
        return cmisTypeDoc;
    }

    public static FolderTypeDefinition getCmisFolderType() {
        return cmisTypeFolder;
    }

    public static RelationshipTypeDefinition getCmisRelationshipType() {
        return cmisTypeRel;
    }

    public static PolicyTypeDefinition getCmisPolicyType() {
        return cmisTypePolicy;
    }

    public static ItemTypeDefinition getCmisItemType() {
        return cmisTypeItem;
    }

    public static SecondaryTypeDefinition getCmisSecondaryType() {
        return cmisTypeSecondary;
    }

    private static void initType(MutableTypeDefinition type, TypeDefinition parentTypeDefinition) {
        type.setBaseTypeId(parentTypeDefinition.getBaseTypeId());
        type.setParentTypeId(parentTypeDefinition.getId());
        type.setIsControllableAcl(parentTypeDefinition.isControllableAcl());
        type.setIsControllablePolicy(parentTypeDefinition.isControllablePolicy());
        type.setIsCreatable(parentTypeDefinition.isCreatable());
        type.setDescription(null);
        type.setDisplayName(null);
        type.setIsFileable(parentTypeDefinition.isFileable());
        type.setIsFulltextIndexed(parentTypeDefinition.isFulltextIndexed());
        type.setIsIncludedInSupertypeQuery(parentTypeDefinition.isIncludedInSupertypeQuery());
        type.setLocalName(null);
        type.setLocalNamespace(parentTypeDefinition.getLocalNamespace());
        type.setIsQueryable(parentTypeDefinition.isQueryable());
        type.setQueryName(null);
        type.setId(null);
        type.setTypeMutability(parentTypeDefinition.getTypeMutability());
    }

    public static MutableDocumentTypeDefinition createDocumentTypeDefinitionWithoutBaseProperties(DocumentTypeDefinition parentTypeDefinition) throws InstantiationException, IllegalAccessException {
        InMemoryDocumentType documentType = new InMemoryDocumentType();
        DocumentTypeCreationHelper.initType((MutableTypeDefinition)documentType, (TypeDefinition)parentTypeDefinition);
        documentType.setIsVersionable(parentTypeDefinition.isVersionable());
        documentType.setContentStreamAllowed(parentTypeDefinition.getContentStreamAllowed());
        return documentType;
    }

    private DocumentTypeCreationHelper() {
    }

    public static List<TypeDefinition> createMapWithDefaultTypes() {
        LinkedList<TypeDefinition> typesList = new LinkedList<TypeDefinition>();
        typesList.addAll(DEFAULT_TYPES);
        return typesList;
    }

    public static List<TypeDefinition> getDefaultTypes() {
        return DEFAULT_TYPES;
    }

    private static void addPropertyDefinition(PropertyDefinition<?> propertyDefinition) {
        if (propertyDefinition.getId().equals("cmis:secondaryObjectTypeIds")) {
            MutablePropertyDefinition propDef = (MutablePropertyDefinition)propertyDefinition;
            propDef.setUpdatability(Updatability.READWRITE);
        }
    }

    private static String getQueryName(String id) {
        if (null == id) {
            return null;
        }
        StringBuilder sb = new StringBuilder(id);
        for (int i = 0; i < sb.length(); ++i) {
            char c = sb.charAt(i);
            if (c != '.' && c != ' ') continue;
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    public static void setDefaultTypeCapabilities(MutableTypeDefinition cmisType) {
        cmisType.setIsCreatable(Boolean.valueOf(true));
        cmisType.setIsFileable(Boolean.valueOf(true));
        cmisType.setIsFulltextIndexed(Boolean.valueOf(false));
    }

    static TypeMutabilityImpl getBaseTypeMutability() {
        TypeMutabilityImpl typeMutability = new TypeMutabilityImpl();
        typeMutability.setCanCreate(Boolean.valueOf(true));
        typeMutability.setCanUpdate(Boolean.valueOf(false));
        typeMutability.setCanDelete(Boolean.valueOf(false));
        return typeMutability;
    }

    private static List<TypeDefinition> createCmisDefaultTypes() {
        TypeDefinitionFactory typeFactoryLocal = DocumentTypeCreationHelper.getTypeDefinitionFactory();
        LinkedList<TypeDefinition> typesList = new LinkedList<TypeDefinition>();
        try {
            cmisTypeDoc = typeFactoryLocal.createDocumentTypeDefinition(CmisVersion.CMIS_1_1, null);
            DocumentTypeCreationHelper.setDefaultTypeCapabilities((MutableTypeDefinition)cmisTypeDoc);
            cmisTypeDoc.setTypeMutability((TypeMutability)DocumentTypeCreationHelper.getBaseTypeMutability());
            cmisTypeDoc.setContentStreamAllowed(ContentStreamAllowed.ALLOWED);
            cmisTypeDoc.setIsVersionable(Boolean.valueOf(false));
            typesList.add((TypeDefinition)cmisTypeDoc);
            cmisTypeFolder = typeFactoryLocal.createFolderTypeDefinition(CmisVersion.CMIS_1_1, null);
            DocumentTypeCreationHelper.setDefaultTypeCapabilities((MutableTypeDefinition)cmisTypeFolder);
            cmisTypeFolder.setTypeMutability((TypeMutability)DocumentTypeCreationHelper.getBaseTypeMutability());
            typesList.add((TypeDefinition)cmisTypeFolder);
            cmisTypeRel = typeFactoryLocal.createRelationshipTypeDefinition(CmisVersion.CMIS_1_1, null);
            DocumentTypeCreationHelper.setDefaultTypeCapabilities((MutableTypeDefinition)cmisTypeRel);
            cmisTypeRel.setTypeMutability((TypeMutability)DocumentTypeCreationHelper.getBaseTypeMutability());
            cmisTypeRel.setIsFileable(Boolean.valueOf(false));
            typesList.add((TypeDefinition)cmisTypeRel);
            cmisTypePolicy = typeFactoryLocal.createPolicyTypeDefinition(CmisVersion.CMIS_1_1, null);
            DocumentTypeCreationHelper.setDefaultTypeCapabilities((MutableTypeDefinition)cmisTypePolicy);
            cmisTypePolicy.setTypeMutability((TypeMutability)DocumentTypeCreationHelper.getBaseTypeMutability());
            cmisTypePolicy.setIsFileable(Boolean.valueOf(false));
            typesList.add((TypeDefinition)cmisTypePolicy);
            cmisTypeItem = typeFactoryLocal.createItemTypeDefinition(CmisVersion.CMIS_1_1, null);
            DocumentTypeCreationHelper.setDefaultTypeCapabilities((MutableTypeDefinition)cmisTypeItem);
            cmisTypeItem.setTypeMutability((TypeMutability)DocumentTypeCreationHelper.getBaseTypeMutability());
            cmisTypeItem.setIsFileable(Boolean.valueOf(true));
            typesList.add((TypeDefinition)cmisTypeItem);
            cmisTypeSecondary = typeFactoryLocal.createSecondaryTypeDefinition(CmisVersion.CMIS_1_1, null);
            DocumentTypeCreationHelper.setDefaultTypeCapabilities((MutableTypeDefinition)cmisTypeSecondary);
            cmisTypeSecondary.setTypeMutability((TypeMutability)DocumentTypeCreationHelper.getBaseTypeMutability());
            cmisTypeSecondary.setIsFileable(Boolean.valueOf(false));
            cmisTypeSecondary.setIsCreatable(Boolean.valueOf(false));
            typesList.add((TypeDefinition)cmisTypeSecondary);
        }
        catch (Exception e) {
            throw new CmisRuntimeException("Error when creating base types. ", (Throwable)e);
        }
        return typesList;
    }

    public static TypeDefinitionFactory getTypeDefinitionFactory() {
        if (null == typeFactory) {
            typeFactory = TypeDefinitionFactory.newInstance();
            typeFactory.setDefaultControllableAcl(true);
            typeFactory.setDefaultControllablePolicy(true);
            typeFactory.setDefaultNamespace("http://apache.org");
            typeFactory.setDefaultIsFulltextIndexed(false);
            typeFactory.setDefaultQueryable(true);
            TypeMutabilityImpl typeMutability = new TypeMutabilityImpl();
            typeMutability.setCanCreate(Boolean.valueOf(true));
            typeMutability.setCanUpdate(Boolean.valueOf(true));
            typeMutability.setCanDelete(Boolean.valueOf(true));
            typeFactory.setDefaultTypeMutability((TypeMutability)typeMutability);
            typeFactory.setDocumentTypeDefinitionClass(InMemoryDocumentType.class);
            typeFactory.setFolderTypeDefinitionClass(InMemoryFolderType.class);
            typeFactory.setRelationshipTypeDefinitionClass(InMemoryRelationshipType.class);
            typeFactory.setPolicyTypeDefinitionClass(InMemoryPolicyType.class);
            typeFactory.setItemTypeDefinitionClass(InMemoryItemType.class);
            typeFactory.setSecondaryTypeDefinitionClass(InMemorySecondaryType.class);
        }
        return typeFactory;
    }

    public static List<TypeDefinition> createDefaultTypes() {
        List<TypeDefinition> typesList = DocumentTypeCreationHelper.createCmisDefaultTypes();
        return typesList;
    }

    public static void setBasicPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        PropertyStringDefinitionImpl propS = PropertyCreationHelper.createStringDefinition("cmis:name", "Name", Updatability.READWRITE);
        propS.setIsRequired(Boolean.valueOf(true));
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        PropertyIdDefinitionImpl propId = PropertyCreationHelper.createIdDefinition("cmis:objectId", "Object Id", Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propId = PropertyCreationHelper.createIdDefinition("cmis:objectTypeId", "Type-Id", Updatability.ONCREATE);
        propId.setIsRequired(Boolean.valueOf(true));
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propId = PropertyCreationHelper.createIdDefinition("cmis:baseTypeId", "Base-Type-Id", Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propS = PropertyCreationHelper.createStringDefinition("cmis:createdBy", "Created By", Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        PropertyDateTimeDefinitionImpl propD = PropertyCreationHelper.createDateTimeDefinition("cmis:creationDate", "Creation Date", Updatability.READONLY);
        propertyDefinitions.put(propD.getId(), (PropertyDefinition<?>)propD);
        propS = PropertyCreationHelper.createStringDefinition("cmis:lastModifiedBy", "Modified By", Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        propD = PropertyCreationHelper.createDateTimeDefinition("cmis:lastModificationDate", "Modification Date", Updatability.READONLY);
        propertyDefinitions.put(propD.getId(), (PropertyDefinition<?>)propD);
        propS = PropertyCreationHelper.createStringDefinition("cmis:changeToken", "Change Token", Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        propS = PropertyCreationHelper.createStringDefinition("cmis:description", "Description", Updatability.READWRITE);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        propId = PropertyCreationHelper.createIdMultiDefinition("cmis:secondaryObjectTypeIds", "Secondary Type Ids", Updatability.READWRITE);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
    }

    public static void setBasicDocumentPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.setBasicPropertyDefinitions(propertyDefinitions);
        PropertyBooleanDefinitionImpl propB = PropertyCreationHelper.createBooleanDefinition("cmis:isImmutable", "Immutable", Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        propB = PropertyCreationHelper.createBooleanDefinition("cmis:isLatestVersion", "Is Latest Version", Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        propB = PropertyCreationHelper.createBooleanDefinition("cmis:isMajorVersion", "Is Major Version", Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        propB = PropertyCreationHelper.createBooleanDefinition("cmis:isLatestMajorVersion", "Is Latest Major Version", Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        PropertyStringDefinitionImpl propS = PropertyCreationHelper.createStringDefinition("cmis:versionLabel", "Version Label", Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        PropertyIdDefinitionImpl propId = PropertyCreationHelper.createIdDefinition("cmis:versionSeriesId", "Version Series Id", Updatability.READONLY);
        propId.setIsQueryable(Boolean.valueOf(false));
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propB = PropertyCreationHelper.createBooleanDefinition("cmis:isVersionSeriesCheckedOut", "Checked Out", Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        propS = PropertyCreationHelper.createStringDefinition("cmis:versionSeriesCheckedOutBy", "Checked Out By", Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        propId = PropertyCreationHelper.createIdDefinition("cmis:versionSeriesCheckedOutId", "Checked Out Id", Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propS = PropertyCreationHelper.createStringDefinition("cmis:checkinComment", "Checkin Comment", Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        PropertyIntegerDefinitionImpl propI = PropertyCreationHelper.createIntegerDefinition("cmis:contentStreamLength", "Content Length", Updatability.READONLY);
        propertyDefinitions.put(propI.getId(), (PropertyDefinition<?>)propI);
        propS = PropertyCreationHelper.createStringDefinition("cmis:contentStreamMimeType", "Mime Type", Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        propS = PropertyCreationHelper.createStringDefinition("cmis:contentStreamFileName", "File Name", Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
        propId = PropertyCreationHelper.createIdDefinition("cmis:contentStreamId", "Stream Id", Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propB = PropertyCreationHelper.createBooleanDefinition("cmis:isPrivateWorkingCopy", "Private Working Copy", Updatability.READONLY);
        propertyDefinitions.put(propB.getId(), (PropertyDefinition<?>)propB);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
    }

    public static void setBasicFolderPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.setBasicPropertyDefinitions(propertyDefinitions);
        PropertyIdDefinitionImpl propId = PropertyCreationHelper.createIdDefinition("cmis:parentId", "Parent Id", Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propId = PropertyCreationHelper.createIdMultiDefinition("cmis:allowedChildObjectTypeIds", "Allowed Child Types", Updatability.READONLY);
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        PropertyStringDefinitionImpl propS = PropertyCreationHelper.createStringDefinition("cmis:path", "Path", Updatability.READONLY);
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
    }

    public static void setBasicPolicyPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.setBasicPropertyDefinitions(propertyDefinitions);
        PropertyStringDefinitionImpl propS = PropertyCreationHelper.createStringDefinition("cmis:policyText", "Policy Text", Updatability.READWRITE);
        propS.setIsRequired(Boolean.valueOf(true));
        propertyDefinitions.put(propS.getId(), (PropertyDefinition<?>)propS);
    }

    public static void setBasicRelationshipPropertyDefinitions(Map<String, PropertyDefinition<?>> propertyDefinitions) {
        DocumentTypeCreationHelper.setBasicPropertyDefinitions(propertyDefinitions);
        PropertyIdDefinitionImpl propId = PropertyCreationHelper.createIdDefinition("cmis:sourceId", "Source Id", Updatability.READWRITE);
        propId.setIsRequired(Boolean.valueOf(true));
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
        propId = PropertyCreationHelper.createIdDefinition("cmis:targetId", "Target Id", Updatability.READWRITE);
        propId.setIsRequired(Boolean.valueOf(true));
        propertyDefinitions.put(propId.getId(), (PropertyDefinition<?>)propId);
    }

    public static void mergePropertyDefinitions(Map<String, PropertyDefinition<?>> existingPpropertyDefinitions, Map<String, PropertyDefinition<?>> newPropertyDefinitions) {
        for (String propId : newPropertyDefinitions.keySet()) {
            if (!existingPpropertyDefinitions.containsKey(propId)) continue;
            throw new CmisInvalidArgumentException("You can't set a property with id " + propId + ". This property id already exists already or exists in supertype");
        }
        existingPpropertyDefinitions.putAll(newPropertyDefinitions);
    }

    public static class InMemorySecondaryType
    extends SecondaryTypeDefinitionImpl {
        private static final long serialVersionUID = 1L;

        public void addPropertyDefinition(PropertyDefinition<?> propertyDefinition) {
            DocumentTypeCreationHelper.addPropertyDefinition(propertyDefinition);
            super.addPropertyDefinition(propertyDefinition);
        }

        public void setId(String id) {
            super.setId(id);
            super.setLocalName(id);
            super.setQueryName(id);
        }
    }

    public static class InMemoryItemType
    extends ItemTypeDefinitionImpl {
        private static final long serialVersionUID = 1L;

        public void addPropertyDefinition(PropertyDefinition<?> propertyDefinition) {
            DocumentTypeCreationHelper.addPropertyDefinition(propertyDefinition);
            super.addPropertyDefinition(propertyDefinition);
        }

        public void setId(String id) {
            super.setId(id);
            super.setLocalName(id);
            super.setQueryName(id);
        }
    }

    public static class InMemoryPolicyType
    extends PolicyTypeDefinitionImpl {
        private static final long serialVersionUID = 1L;

        public void addPropertyDefinition(PropertyDefinition<?> propertyDefinition) {
            DocumentTypeCreationHelper.addPropertyDefinition(propertyDefinition);
            super.addPropertyDefinition(propertyDefinition);
        }

        public void setId(String id) {
            super.setId(id);
            super.setLocalName(id);
            super.setQueryName(DocumentTypeCreationHelper.getQueryName(id));
        }
    }

    public static class InMemoryRelationshipType
    extends RelationshipTypeDefinitionImpl {
        private static final long serialVersionUID = 1L;

        public void addPropertyDefinition(PropertyDefinition<?> propertyDefinition) {
            DocumentTypeCreationHelper.addPropertyDefinition(propertyDefinition);
            super.addPropertyDefinition(propertyDefinition);
        }

        public void setId(String id) {
            super.setId(id);
            super.setLocalName(id);
            super.setQueryName(DocumentTypeCreationHelper.getQueryName(id));
        }
    }

    public static class InMemoryFolderType
    extends FolderTypeDefinitionImpl {
        private static final long serialVersionUID = 1L;

        public void addPropertyDefinition(PropertyDefinition<?> propertyDefinition) {
            DocumentTypeCreationHelper.addPropertyDefinition(propertyDefinition);
            super.addPropertyDefinition(propertyDefinition);
        }

        public void setId(String id) {
            super.setId(id);
            super.setLocalName(id);
            super.setQueryName(DocumentTypeCreationHelper.getQueryName(id));
        }
    }

    public static class InMemoryDocumentType
    extends DocumentTypeDefinitionImpl {
        private static final long serialVersionUID = 1L;

        public void addPropertyDefinition(PropertyDefinition<?> propertyDefinition) {
            DocumentTypeCreationHelper.addPropertyDefinition(propertyDefinition);
            super.addPropertyDefinition(propertyDefinition);
        }

        public void setId(String id) {
            super.setId(id);
            super.setLocalName(id);
            super.setQueryName(DocumentTypeCreationHelper.getQueryName(id));
        }
    }
}

