/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package org.netbeans.modules.html.editor.lib.api.validation;

import java.util.Collection;
import org.netbeans.modules.html.editor.lib.api.HtmlVersion;
import org.openide.util.Lookup;

/**
 *
 * @author marekfukala
 */
public class ValidatorService {

    public static Validator getValidator(HtmlVersion version) {
        Collection<? extends Validator> validators = Lookup.getDefault().lookupAll(Validator.class);
        for(Validator v : validators) {
            if(v.canValidate(version)) {
                return v;
            }
        }

        return null;
    }
   

}
