/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.jsr303;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Locale;
import java.util.Map;
import javax.validation.ConstraintDefinitionException;
import javax.validation.Payload;
import javax.validation.ValidationException;
import org.apache.bval.jsr303.util.SecureActions;
import org.apache.commons.lang3.reflect.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ConstraintAnnotationAttributes {
    MESSAGE,
    GROUPS,
    PAYLOAD,
    VALUE(true);

    private Type type;
    private boolean permitNullDefaultValue;

    private ConstraintAnnotationAttributes() {
        this(false);
    }

    private ConstraintAnnotationAttributes(boolean permitNullDefaultValue) {
        this.permitNullDefaultValue = permitNullDefaultValue;
        try {
            this.type = Types.class.getDeclaredField(this.getAttributeName()).getGenericType();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Type getType() {
        return this.type;
    }

    public String getAttributeName() {
        return this.name().toLowerCase(Locale.US);
    }

    public <V> Object put(Map<? super String, ? super V> map, V value) {
        if (!TypeUtils.isInstance(value, this.getType())) {
            throw new IllegalArgumentException(String.format("Invalid '%s' value: %s", this.getAttributeName(), value));
        }
        return map.put(this.getAttributeName(), value);
    }

    public <V> V get(Map<? super String, ? super V> map) {
        V result = map.get(this.getAttributeName());
        if (!TypeUtils.isInstance(result, this.getType())) {
            throw new IllegalStateException(String.format("Invalid '%s' value: %s", this.getAttributeName(), result));
        }
        return result;
    }

    public <A extends Annotation> void validateOn(Class<A> type) {
        new Worker<A>(type);
    }

    public <A extends Annotation> boolean isDeclaredOn(Class<A> type) {
        return (ConstraintAnnotationAttributes)this.new Worker<A>(type, (boolean)true).valid;
    }

    public <T> T getValue(Annotation constraint) {
        try {
            Object result = new Worker<Annotation>(constraint.annotationType()).read(constraint);
            return result;
        }
        catch (Exception e) {
            throw new ValidationException(String.format("Could not get value of %1$s() from %2$s", this.getType(), constraint));
        }
    }

    public <T, A extends Annotation> T getDefaultValue(Class<A> type) {
        Object result = (ConstraintAnnotationAttributes)this.new Worker<A>(type).defaultValue;
        return (T)result;
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() != null) {
            return AccessController.doPrivileged(action);
        }
        return action.run();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Worker<C> {
        final Method method;
        final Object defaultValue;
        final boolean valid;

        Worker(Class<C> constraintType) {
            this(constraintType, false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Worker(Class<C> constraintType, boolean quiet) {
            boolean _valid = true;
            Object _defaultValue = null;
            try {
                this.method = (Method)ConstraintAnnotationAttributes.doPrivileged(SecureActions.getPublicMethod(constraintType, ConstraintAnnotationAttributes.this.getAttributeName()));
                if (this.method == null) {
                    if (quiet) {
                        _valid = false;
                        return;
                    }
                    throw new ConstraintDefinitionException(String.format("Annotation %1$s has no %2$s() method", constraintType, ConstraintAnnotationAttributes.this.getAttributeName()));
                }
                if (!TypeUtils.isAssignable(this.method.getReturnType(), ConstraintAnnotationAttributes.this.getType())) {
                    if (quiet) {
                        _valid = false;
                        return;
                    }
                    throw new ConstraintDefinitionException(String.format("Return type for %1$s() must be of type %2$s", ConstraintAnnotationAttributes.this.getAttributeName(), ConstraintAnnotationAttributes.this.getType()));
                }
                _defaultValue = this.method.getDefaultValue();
                if (_defaultValue == null && ConstraintAnnotationAttributes.this.permitNullDefaultValue) {
                    return;
                }
                if (TypeUtils.isArrayType(ConstraintAnnotationAttributes.this.getType()) && Array.getLength(_defaultValue) > 0) {
                    if (quiet) {
                        _valid = false;
                        return;
                    }
                    throw new ConstraintDefinitionException(String.format("Default value for %1$s() must be an empty array", ConstraintAnnotationAttributes.this.getAttributeName()));
                }
            }
            finally {
                this.valid = _valid;
                this.defaultValue = _defaultValue;
            }
        }

        <T> T read(final C constraint) {
            Object result = ConstraintAnnotationAttributes.doPrivileged(new PrivilegedAction<Object>(){

                @Override
                public Object run() {
                    try {
                        Worker.this.method.setAccessible(true);
                        return Worker.this.method.invoke(constraint, new Object[0]);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            return (T)result;
        }
    }

    private static class Types {
        String message;
        Class<?>[] groups;
        Class<? extends Payload>[] payload;
        Annotation[] value;

        private Types() {
        }
    }
}

