/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.jdbc.kernel;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import org.apache.openjpa.jdbc.conf.JDBCConfiguration;
import org.apache.openjpa.jdbc.conf.JDBCConfigurationImpl;
import org.apache.openjpa.jdbc.identifier.DBIdentifier;
import org.apache.openjpa.jdbc.identifier.QualifiedDBIdentifier;
import org.apache.openjpa.jdbc.kernel.AbstractJDBCSeq;
import org.apache.openjpa.jdbc.kernel.JDBCStore;
import org.apache.openjpa.jdbc.meta.ClassMapping;
import org.apache.openjpa.jdbc.schema.Schema;
import org.apache.openjpa.jdbc.schema.SchemaGroup;
import org.apache.openjpa.jdbc.schema.SchemaTool;
import org.apache.openjpa.jdbc.schema.Schemas;
import org.apache.openjpa.jdbc.schema.Sequence;
import org.apache.openjpa.jdbc.sql.DBDictionary;
import org.apache.openjpa.lib.conf.Configurable;
import org.apache.openjpa.lib.conf.Configuration;
import org.apache.openjpa.lib.conf.Configurations;
import org.apache.openjpa.lib.log.Log;
import org.apache.openjpa.lib.util.Localizer;
import org.apache.openjpa.lib.util.Options;
import org.apache.openjpa.util.MetaDataException;
import org.apache.openjpa.util.UserException;

public class NativeJDBCSeq
extends AbstractJDBCSeq
implements Configurable {
    public static final String ACTION_DROP = "drop";
    public static final String ACTION_ADD = "add";
    public static final String ACTION_GET = "get";
    private static Localizer _loc = Localizer.forPackage(NativeJDBCSeq.class);
    private JDBCConfiguration _conf = null;
    private DBIdentifier _seqName = DBIdentifier.newSequence("OPENJPA_SEQUENCE");
    private int _increment = 1;
    private int _initial = 1;
    private int _allocate = 50;
    private Sequence _seq = null;
    private String _select = null;
    private long _nextValue = 0L;
    private long _maxValue = -1L;
    private DBIdentifier _schema = DBIdentifier.NULL;
    private boolean alterIncrementBy = false;
    private boolean alreadyLoggedAlterSeqFailure = false;
    private boolean alreadyLoggedAlterSeqDisabled = false;

    public String getSequence() {
        return this._seqName.getName();
    }

    public void setSequence(String seqName) {
        this._seqName = DBIdentifier.newSequence(seqName);
    }

    public int getInitialValue() {
        return this._initial;
    }

    public void setInitialValue(int initial) {
        this._initial = initial;
    }

    public int getAllocate() {
        return this._allocate;
    }

    public void setAllocate(int allocate) {
        this._allocate = allocate;
    }

    public int getIncrement() {
        return this._increment;
    }

    public void setIncrement(int increment) {
        this._increment = increment;
    }

    @Override
    public void addSchema(ClassMapping mapping, SchemaGroup group) {
        Schema schema;
        QualifiedDBIdentifier path = QualifiedDBIdentifier.getPath(this._seqName);
        if (group.isKnownSequence(path)) {
            return;
        }
        DBIdentifier schemaName = this.getSchemaIdentifier();
        if (DBIdentifier.isEmpty(schemaName) && DBIdentifier.isEmpty(schemaName = path.getSchemaName())) {
            schemaName = Schemas.getNewTableSchemaIdentifier(this._conf);
        }
        if ((schema = group.getSchema(schemaName)) == null) {
            schema = group.addSchema(schemaName);
        }
        schema.importSequence(this._seq);
    }

    @Override
    public JDBCConfiguration getConfiguration() {
        return this._conf;
    }

    @Override
    public void setConfiguration(Configuration conf) {
        this._conf = (JDBCConfiguration)conf;
    }

    @Override
    public void startConfiguration() {
    }

    @Override
    public void endConfiguration() {
        this.buildSequence();
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        String format = dict.nextSequenceQuery;
        if (format == null) {
            throw new MetaDataException(_loc.get("no-seq-sql", this._seqName));
        }
        String name = dict.getFullName(this._seq);
        this._select = MessageFormat.format(format, name, String.valueOf(this._allocate * this._increment));
        this.type = dict.nativeSequenceType;
    }

    @Override
    protected synchronized Object nextInternal(JDBCStore store, ClassMapping mapping) throws SQLException {
        if (!this.alterIncrementBy) {
            this.allocateInternal(0, store, mapping);
            this.alterIncrementBy = true;
        }
        if (this._nextValue >= this._maxValue) {
            this.allocateInternal(0, store, mapping);
        }
        long result = this._nextValue;
        this._nextValue += (long)this._increment;
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected synchronized void allocateInternal(int additional, JDBCStore store, ClassMapping mapping) throws SQLException {
        Connection conn = this.getConnection(store);
        try {
            if (!this.alterIncrementBy) {
                DBDictionary dict = this._conf.getDBDictionaryInstance();
                if (!dict.disableAlterSeqenceIncrementBy) {
                    if (this.updateSql(conn, dict.getAlterSequenceSQL(this._seq)) == -1) {
                        Log log;
                        if (!this.alreadyLoggedAlterSeqFailure && (log = this._conf.getLog("openjpa.Runtime")).isWarnEnabled()) {
                            log.warn(_loc.get("fallback-no-seq-cache", this._seqName));
                        }
                        this.alreadyLoggedAlterSeqFailure = true;
                        this._allocate = 1;
                    }
                } else {
                    Log log;
                    if (!this.alreadyLoggedAlterSeqDisabled && (log = this._conf.getLog("openjpa.Runtime")).isWarnEnabled()) {
                        log.warn(_loc.get("alter-seq-disabled", this._seqName));
                    }
                    this.alreadyLoggedAlterSeqDisabled = true;
                }
            }
            this._nextValue = this.getSequence(conn);
            this._maxValue = this._nextValue + (long)(this._allocate * this._increment);
        }
        finally {
            this.closeConnection(conn);
        }
    }

    private void buildSequence() {
        QualifiedDBIdentifier path = QualifiedDBIdentifier.getPath(this._seqName);
        DBIdentifier seqName = path.getIdentifier();
        DBIdentifier schemaName = this._schema;
        if (DBIdentifier.isEmpty(schemaName) && DBIdentifier.isEmpty(schemaName = path.getSchemaName())) {
            schemaName = Schemas.getNewTableSchemaIdentifier(this._conf);
        }
        SchemaGroup group = new SchemaGroup();
        Schema schema = group.addSchema(schemaName);
        this._seq = schema.addSequence(seqName);
        this._seq.setInitialValue(this._initial);
        this._seq.setIncrement(this._increment);
        this._seq.setAllocate(this._allocate);
    }

    public void refreshSequence() throws SQLException {
        Log log = this._conf.getLog("openjpa.Runtime");
        if (log.isInfoEnabled()) {
            log.info(_loc.get("make-native-seq"));
        }
        SchemaTool tool = new SchemaTool(this._conf);
        tool.setIgnoreErrors(true);
        tool.createSequence(this._seq);
    }

    public void dropSequence() throws SQLException {
        Log log = this._conf.getLog("openjpa.Runtime");
        if (log.isInfoEnabled()) {
            log.info(_loc.get("drop-native-seq"));
        }
        SchemaTool tool = new SchemaTool(this._conf);
        tool.setIgnoreErrors(true);
        tool.dropSequence(this._seq);
    }

    private long getSequence(Connection conn) throws SQLException {
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        PreparedStatement stmnt = null;
        ResultSet rs = null;
        try {
            stmnt = conn.prepareStatement(this._select);
            dict.setTimeouts(stmnt, this._conf, false);
            rs = stmnt.executeQuery();
            if (rs.next()) {
                long l = rs.getLong(1);
                return l;
            }
            throw new UserException(_loc.get("invalid-seq-sql", this._select));
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException se) {}
            }
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int updateSql(Connection conn, String sql2) throws SQLException {
        DBDictionary dict = this._conf.getDBDictionaryInstance();
        PreparedStatement stmnt = null;
        int rc = -1;
        try {
            stmnt = conn.prepareStatement(sql2);
            dict.setTimeouts(stmnt, this._conf, false);
            rc = stmnt.executeUpdate();
        }
        catch (Exception e) {
        }
        finally {
            if (stmnt != null) {
                try {
                    stmnt.close();
                }
                catch (SQLException se) {}
            }
        }
        return rc;
    }

    public static void main(String[] args) throws Exception {
        Options opts = new Options();
        final String[] arguments = opts.setFromCmdLine(args);
        boolean ret = Configurations.runAgainstAllAnchors(opts, new Configurations.Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public boolean run(Options opts) throws Exception {
                JDBCConfigurationImpl conf = new JDBCConfigurationImpl();
                try {
                    boolean bl = NativeJDBCSeq.run((JDBCConfiguration)conf, arguments, opts);
                    return bl;
                }
                finally {
                    conf.close();
                }
            }
        });
        if (!ret) {
            System.out.println(_loc.get("native-seq-usage"));
        }
    }

    public static boolean run(JDBCConfiguration conf, String[] args, Options opts) throws Exception {
        String action = opts.removeProperty("action", "a", null);
        Configurations.populateConfiguration(conf, opts);
        return NativeJDBCSeq.run(conf, args, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean run(JDBCConfiguration conf, String[] args, String action) throws Exception {
        if (args.length != 0) {
            return false;
        }
        NativeJDBCSeq seq = new NativeJDBCSeq();
        String props = Configurations.getProperties(conf.getSequence());
        Configurations.configureInstance((Object)seq, (Configuration)conf, props);
        if (ACTION_DROP.equals(action)) {
            seq.dropSequence();
        } else if (ACTION_ADD.equals(action)) {
            seq.refreshSequence();
        } else {
            if (ACTION_GET.equals(action)) {
                Connection conn = conf.getDataSource2(null).getConnection();
                try {
                    long cur = seq.getSequence(conn);
                    System.out.println(cur);
                }
                finally {
                    try {
                        conn.close();
                    }
                    catch (SQLException se) {}
                }
            }
            return false;
        }
        return true;
    }

    public void setSchema(String schema) {
        this._schema = DBIdentifier.newSchema(schema);
    }

    public String getSchema() {
        return this._schema.getName();
    }

    public DBIdentifier getSchemaIdentifier() {
        return this._schema;
    }
}

