/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.lib.util.concurrent;

import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.collections.set.MapBackedSet;
import org.apache.openjpa.lib.util.concurrent.ConcurrentReferenceHashMap;

public class ConcurrentReferenceHashSet<E>
implements Set<E>,
Serializable {
    public static final int HARD = 0;
    public static final int SOFT = 1;
    public static final int WEAK = 2;
    private static final Object DUMMY_VAL = new Object();
    private final Set<E> _set;

    public ConcurrentReferenceHashSet(int refType) {
        if (refType == 0) {
            this._set = MapBackedSet.decorate(new ConcurrentHashMap(), DUMMY_VAL);
        } else {
            int mapRefType = refType == 2 ? 1 : 2;
            this._set = MapBackedSet.decorate(new ConcurrentReferenceHashMap(mapRefType, 0), DUMMY_VAL);
        }
    }

    @Override
    public boolean add(E obj) {
        return this._set.add(obj);
    }

    @Override
    public boolean addAll(Collection<? extends E> coll) {
        return this._set.addAll(coll);
    }

    @Override
    public void clear() {
        this._set.clear();
    }

    @Override
    public boolean contains(Object obj) {
        return this._set.contains(obj);
    }

    @Override
    public boolean containsAll(Collection<?> coll) {
        return this._set.containsAll(coll);
    }

    @Override
    public boolean isEmpty() {
        return this._set.isEmpty();
    }

    @Override
    public Iterator<E> iterator() {
        return this._set.iterator();
    }

    @Override
    public boolean remove(Object obj) {
        return this._set.remove(obj);
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        return this._set.removeAll(coll);
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        return this._set.retainAll(coll);
    }

    @Override
    public int size() {
        return this._set.size();
    }

    @Override
    public Object[] toArray() {
        return this._set.toArray();
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        return this._set.toArray(arr);
    }

    @Override
    public int hashCode() {
        return this._set.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof ConcurrentReferenceHashSet) {
            obj = ((ConcurrentReferenceHashSet)obj)._set;
        }
        return this._set.equals(obj);
    }
}

