/*
 * Decompiled with CFR 0.152.
 */
package rx.internal.operators;

import rx.Observable;
import rx.Producer;
import rx.Subscriber;
import rx.exceptions.Exceptions;
import rx.exceptions.OnErrorThrowable;
import rx.functions.Func1;
import rx.internal.util.RxJavaPluginUtils;

public final class OperatorFilter<T>
implements Observable.Operator<T, T> {
    final Func1<? super T, Boolean> predicate;

    public OperatorFilter(Func1<? super T, Boolean> predicate) {
        this.predicate = predicate;
    }

    @Override
    public Subscriber<? super T> call(Subscriber<? super T> child) {
        FilterSubscriber<? super T> parent = new FilterSubscriber<T>(child, this.predicate);
        child.add(parent);
        return parent;
    }

    static final class FilterSubscriber<T>
    extends Subscriber<T> {
        final Subscriber<? super T> actual;
        final Func1<? super T, Boolean> predicate;
        boolean done;

        public FilterSubscriber(Subscriber<? super T> actual, Func1<? super T, Boolean> predicate) {
            this.actual = actual;
            this.predicate = predicate;
            this.request(0L);
        }

        @Override
        public void onNext(T t) {
            boolean result;
            try {
                result = this.predicate.call(t);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.unsubscribe();
                this.onError(OnErrorThrowable.addValueAsLastCause(ex, t));
                return;
            }
            if (result) {
                this.actual.onNext(t);
            } else {
                this.request(1L);
            }
        }

        @Override
        public void onError(Throwable e) {
            if (this.done) {
                RxJavaPluginUtils.handleException(e);
                return;
            }
            this.done = true;
            this.actual.onError(e);
        }

        @Override
        public void onCompleted() {
            if (this.done) {
                return;
            }
            this.actual.onCompleted();
        }

        @Override
        public void setProducer(Producer p) {
            super.setProducer(p);
            this.actual.setProducer(p);
        }
    }
}

