/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.vertx.client.tcp;

import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import java.util.concurrent.TimeoutException;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpData;
import org.apache.servicecomb.foundation.vertx.client.tcp.TcpResponseCallback;

public class TcpRequest {
    private long begin;
    private long msTimeout;
    private Context callContext = Vertx.currentContext();
    private long threadId = Thread.currentThread().getId();
    private TcpResponseCallback responseCallback;

    public TcpRequest(long msTimeout, TcpResponseCallback responseCallback) {
        this.begin = System.currentTimeMillis();
        this.msTimeout = msTimeout;
        this.responseCallback = responseCallback;
    }

    public void onReply(Buffer headerBuffer, Buffer bodyBuffer) {
        TcpData tcpData = new TcpData(headerBuffer, bodyBuffer);
        if (this.callContext == null || this.threadId == Thread.currentThread().getId()) {
            this.responseCallback.success(tcpData);
            return;
        }
        this.callContext.runOnContext(Void2 -> this.responseCallback.success(tcpData));
    }

    public void onSendError(Throwable e) {
        this.responseCallback.fail(e);
    }

    public boolean isTimeout() {
        return System.currentTimeMillis() - this.begin >= this.msTimeout;
    }

    public void onTimeout(TimeoutException e) {
        this.responseCallback.fail(e);
    }
}

