/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar;

import com.fasterxml.jackson.databind.JavaType;
import io.protostuff.InputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;
import org.apache.servicecomb.foundation.protobuf.internal.schema.deserializer.scalar.AbstractScalarReadSchemas;

public class Int32ReadSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        JavaType javaType = propertyDescriptor.getJavaType();
        if (Integer.TYPE.equals(javaType.getRawClass())) {
            return new Int32PrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Integer.class.equals((Object)javaType.getRawClass()) || javaType.isJavaLangObject()) {
            return new Int32Schema(protoField, propertyDescriptor);
        }
        ProtoUtils.throwNotSupportMerge(protoField, propertyDescriptor.getJavaType());
        return null;
    }

    private static class Int32PrimitiveSchema<T>
    extends AbstractScalarReadSchemas.AbstractIntPrimitiveSchema<T> {
        public Int32PrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            int value = input.readInt32();
            this.setter.set(message, value);
            return input.readFieldNumber();
        }
    }

    private static class Int32Schema<T>
    extends AbstractScalarReadSchemas.AbstractIntSchema<T> {
        public Int32Schema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
        }

        @Override
        public int mergeFrom(InputEx input, T message) throws IOException {
            int value = input.readInt32();
            this.setter.set(message, (Object)value);
            return input.readFieldNumber();
        }
    }
}

