/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.foundation.protobuf.internal.schema.serializer.scalar;

import io.protostuff.OutputEx;
import io.protostuff.compiler.model.Field;
import io.protostuff.runtime.FieldSchema;
import java.io.IOException;
import org.apache.servicecomb.foundation.common.utils.bean.Getter;
import org.apache.servicecomb.foundation.common.utils.bean.IntGetter;
import org.apache.servicecomb.foundation.protobuf.internal.ProtoUtils;
import org.apache.servicecomb.foundation.protobuf.internal.bean.PropertyDescriptor;

public class Fixed32WriteSchemas {
    public static <T> FieldSchema<T> create(Field protoField, PropertyDescriptor propertyDescriptor) {
        if (Integer.TYPE.equals(propertyDescriptor.getJavaType().getRawClass())) {
            return new Fixed32PrimitiveSchema(protoField, propertyDescriptor);
        }
        if (Integer.class.equals((Object)propertyDescriptor.getJavaType().getRawClass())) {
            return new Fixed32Schema(protoField, propertyDescriptor);
        }
        return new Fixed32DynamicSchema(protoField, propertyDescriptor);
    }

    private static class Fixed32PrimitiveSchema<T>
    extends Fixed32DynamicSchema<T> {
        private final IntGetter<T> primitiveGetter;

        public Fixed32PrimitiveSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.primitiveGetter = (IntGetter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            int value = this.primitiveGetter.get(message);
            output.writeScalarFixed32(this.tag, this.tagSize, value);
        }
    }

    private static class Fixed32Schema<T>
    extends Fixed32DynamicSchema<T> {
        protected final Getter<T, Integer> getter;

        public Fixed32Schema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor);
            this.getter = (Getter)propertyDescriptor.getGetter();
        }

        @Override
        public final void getAndWriteTo(OutputEx output, T message) throws IOException {
            Integer value = (Integer)this.getter.get(message);
            if (value != null) {
                output.writeScalarFixed32(this.tag, this.tagSize, value);
            }
        }
    }

    private static class Fixed32DynamicSchema<T>
    extends FieldSchema<T> {
        public Fixed32DynamicSchema(Field protoField, PropertyDescriptor propertyDescriptor) {
            super(protoField, propertyDescriptor.getJavaType());
        }

        @Override
        public final void writeTo(OutputEx output, Object value) throws IOException {
            if (value instanceof Number) {
                output.writeScalarFixed32(this.tag, this.tagSize, ((Number)value).intValue());
                return;
            }
            if (value instanceof String[]) {
                if (((String[])value).length == 0) {
                    return;
                }
                int parsedValue = Integer.parseInt(((String[])value)[0], 10);
                output.writeScalarFixed32(this.tag, this.tagSize, parsedValue);
                return;
            }
            if (value instanceof String) {
                int parsedValue = Integer.parseInt((String)value, 10);
                output.writeScalarFixed32(this.tag, this.tagSize, parsedValue);
                return;
            }
            ProtoUtils.throwNotSupportWrite(this.protoField, value);
        }
    }
}

