/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.health;

import java.util.HashMap;
import org.springframework.boot.actuate.health.AbstractHealthIndicator;
import org.springframework.boot.actuate.health.Health;
import org.springframework.cloud.context.properties.ConfigurationPropertiesRebinder;
import org.springframework.cloud.context.scope.refresh.RefreshScope;

public class RefreshScopeHealthIndicator
extends AbstractHealthIndicator {
    private RefreshScope scope;
    private ConfigurationPropertiesRebinder rebinder;

    public RefreshScopeHealthIndicator(RefreshScope scope, ConfigurationPropertiesRebinder rebinder) {
        this.scope = scope;
        this.rebinder = rebinder;
    }

    protected void doHealthCheck(Health.Builder builder) throws Exception {
        HashMap<String, Exception> errors = new HashMap<String, Exception>(this.scope.getErrors());
        errors.putAll(this.rebinder.getErrors());
        if (errors.isEmpty()) {
            builder.up();
        } else {
            builder.down();
            if (errors.size() == 1) {
                builder.withException((Exception)errors.values().iterator().next());
            } else {
                for (String name : errors.keySet()) {
                    builder.withDetail(name, errors.get(name));
                }
            }
        }
    }
}

