/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.loadbalancer;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.netflix.loadbalancer.AbstractServerPredicate;
import com.netflix.loadbalancer.PredicateKey;
import com.netflix.loadbalancer.Server;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;

public class CompositePredicate
extends AbstractServerPredicate {
    private AbstractServerPredicate delegate;
    private List<AbstractServerPredicate> fallbacks = Lists.newArrayList();
    private int minimalFilteredServers = 1;
    private float minimalFilteredPercentage = 0.0f;

    public boolean apply(@Nullable PredicateKey input) {
        return this.delegate.apply(input);
    }

    public static Builder withPredicates(AbstractServerPredicate ... primaryPredicates) {
        return new Builder(primaryPredicates);
    }

    public static Builder withPredicate(AbstractServerPredicate primaryPredicate) {
        return new Builder(primaryPredicate);
    }

    @Override
    public List<Server> getEligibleServers(List<Server> servers, Object loadBalancerKey) {
        List<Server> result = super.getEligibleServers(servers, loadBalancerKey);
        Iterator<AbstractServerPredicate> i = this.fallbacks.iterator();
        while ((result.size() < this.minimalFilteredServers || result.size() <= (int)((float)servers.size() * this.minimalFilteredPercentage)) && i.hasNext()) {
            AbstractServerPredicate predicate = i.next();
            result = predicate.getEligibleServers(servers, loadBalancerKey);
        }
        return result;
    }

    public static class Builder {
        private CompositePredicate toBuild = new CompositePredicate();

        Builder(AbstractServerPredicate primaryPredicate) {
            this.toBuild.delegate = primaryPredicate;
        }

        Builder(AbstractServerPredicate ... primaryPredicates) {
            Predicate chain = Predicates.and((Predicate[])primaryPredicates);
            this.toBuild.delegate = AbstractServerPredicate.ofKeyPredicate((Predicate<PredicateKey>)chain);
        }

        public Builder addFallbackPredicate(AbstractServerPredicate fallback) {
            this.toBuild.fallbacks.add(fallback);
            return this;
        }

        public Builder setFallbackThresholdAsMinimalFilteredNumberOfServers(int number) {
            this.toBuild.minimalFilteredServers = number;
            return this;
        }

        public Builder setFallbackThresholdAsMinimalFilteredPercentage(float percent) {
            this.toBuild.minimalFilteredPercentage = percent;
            return this;
        }

        public CompositePredicate build() {
            return this.toBuild;
        }
    }
}

