/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.gateway.route;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.cloud.gateway.event.RefreshRoutesEvent;
import org.springframework.cloud.gateway.route.RouteDefinition;
import org.springframework.cloud.gateway.route.RouteDefinitionLocator;
import org.springframework.context.ApplicationListener;
import reactor.cache.CacheFlux;
import reactor.core.publisher.Flux;

public class CachingRouteDefinitionLocator
implements RouteDefinitionLocator,
ApplicationListener<RefreshRoutesEvent> {
    private final RouteDefinitionLocator delegate;
    private final Flux<RouteDefinition> routeDefinitions;
    private final Map<String, List> cache = new HashMap<String, List>();

    public CachingRouteDefinitionLocator(RouteDefinitionLocator delegate) {
        this.delegate = delegate;
        this.routeDefinitions = CacheFlux.lookup(this.cache, (Object)"routeDefs", RouteDefinition.class).onCacheMissResume(this.delegate::getRouteDefinitions);
    }

    @Override
    public Flux<RouteDefinition> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    public Flux<RouteDefinition> refresh() {
        this.cache.clear();
        return this.routeDefinitions;
    }

    public void onApplicationEvent(RefreshRoutesEvent event) {
        this.refresh();
    }

    @Deprecated
    void handleRefresh() {
        this.refresh();
    }
}

