/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.actuate.cloudfoundry;

import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import org.springframework.boot.actuate.cloudfoundry.CloudFoundryAuthorizationException;
import org.springframework.boot.json.JsonParserFactory;
import org.springframework.util.Base64Utils;
import org.springframework.util.StringUtils;

class Token {
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final String encoded;
    private final String signature;
    private final Map<String, Object> header;
    private final Map<String, Object> claims;

    Token(String encoded) {
        this.encoded = encoded;
        int firstPeriod = encoded.indexOf(46);
        int lastPeriod = encoded.lastIndexOf(46);
        if (firstPeriod <= 0 || lastPeriod <= firstPeriod) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_TOKEN, "JWT must have header, body and signature");
        }
        this.header = this.parseJson(encoded.substring(0, firstPeriod));
        this.claims = this.parseJson(encoded.substring(firstPeriod + 1, lastPeriod));
        this.signature = encoded.substring(lastPeriod + 1);
        if (!StringUtils.hasLength((String)this.signature)) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_TOKEN, "Token must have non-empty crypto segment");
        }
    }

    private Map<String, Object> parseJson(String base64) {
        try {
            byte[] bytes = Base64Utils.decodeFromUrlSafeString((String)base64);
            return JsonParserFactory.getJsonParser().parseMap(new String(bytes, UTF_8));
        }
        catch (RuntimeException ex) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_TOKEN, "Token could not be parsed", ex);
        }
    }

    public byte[] getContent() {
        return this.encoded.substring(0, this.encoded.lastIndexOf(".")).getBytes();
    }

    public byte[] getSignature() {
        return Base64Utils.decodeFromUrlSafeString((String)this.signature);
    }

    public String getSignatureAlgorithm() {
        return this.getRequired(this.header, "alg", String.class);
    }

    public String getIssuer() {
        return this.getRequired(this.claims, "iss", String.class);
    }

    public long getExpiry() {
        return this.getRequired(this.claims, "exp", Integer.class).longValue();
    }

    public List<String> getScope() {
        return this.getRequired(this.claims, "scope", List.class);
    }

    public String getKeyId() {
        return this.getRequired(this.header, "kid", String.class);
    }

    private <T> T getRequired(Map<String, Object> map, String key, Class<T> type) {
        Object value = map.get(key);
        if (value == null) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_TOKEN, "Unable to get value from key " + key);
        }
        if (!type.isInstance(value)) {
            throw new CloudFoundryAuthorizationException(CloudFoundryAuthorizationException.Reason.INVALID_TOKEN, "Unexpected value type from key " + key + " value " + value);
        }
        return (T)value;
    }

    public String toString() {
        return this.encoded;
    }
}

