/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.config.client;

import com.google.common.base.Joiner;
import com.netflix.config.ConcurrentCompositeConfiguration;
import java.util.List;
import org.apache.servicecomb.deployment.Deployment;

public final class ConfigCenterConfig {
    public static final ConfigCenterConfig INSTANCE = new ConfigCenterConfig();
    private static ConcurrentCompositeConfiguration finalConfig;
    private static final String AUTO_DISCOVERY_ENABLED = "servicecomb.service.registry.autodiscovery";
    private static final String REFRESH_MODE = "servicecomb.config.client.refreshMode";
    private static final String REFRESH_PORT = "servicecomb.config.client.refreshPort";
    private static final String TENANT_NAME = "servicecomb.config.client.tenantName";
    private static final String DOMAIN_NAME = "servicecomb.config.client.domainName";
    private static final String TOKEN_NAME = "servicecomb.config.client.token";
    private static final String URI_API_VERSION = "servicecomb.config.client.api.version";
    private static final String REFRESH_INTERVAL = "servicecomb.config.client.refresh_interval";
    private static final String FIRST_REFRESH_INTERVAL = "servicecomb.config.client.first_refresh_interval";
    private static final String SERVICE_NAME = "service_description.name";
    private static final String SERVICE_VERSION = "service_description.version";
    private static final String APPLICATION_NAME = "APPLICATION_ID";
    private static final String INSTANCE_TAGS = "instance_description.properties.tags";
    public static final String PROXY_PRE_NAME = "servicecomb.proxy.";
    public static final String PROXY_ENABLE = "servicecomb.proxy.enable";
    public static final String PROXY_HOST = "servicecomb.proxy.host";
    public static final String PROXY_PORT = "servicecomb.proxy.port";
    public static final String PROXY_USERNAME = "servicecomb.proxy.username";
    public static final String PROXY_PASSWD = "servicecomb.proxy.passwd";
    private static final int DEFAULT_REFRESH_MODE = 0;
    private static final int DEFAULT_REFRESH_PORT = 30104;
    private static final int DEFAULT_REFRESH_INTERVAL = 30000;
    private static final int DEFAULT_FIRST_REFRESH_INTERVAL = 0;
    private static final int DEFAULT_TIMEOUT_IN_MS = 30000;

    private ConfigCenterConfig() {
    }

    public static void setConcurrentCompositeConfiguration(ConcurrentCompositeConfiguration config) {
        finalConfig = config;
    }

    public ConcurrentCompositeConfiguration getConcurrentCompositeConfiguration() {
        return finalConfig;
    }

    public int getRefreshMode() {
        return finalConfig.getInt(REFRESH_MODE, 0);
    }

    public int getRefreshPort() {
        return finalConfig.getInt(REFRESH_PORT, 30104);
    }

    public String getTenantName() {
        return finalConfig.getString(TENANT_NAME, "default");
    }

    public String getDomainName() {
        return finalConfig.getString(DOMAIN_NAME, "default");
    }

    public String getToken() {
        return finalConfig.getString(TOKEN_NAME, null);
    }

    public String getApiVersion() {
        return finalConfig.getString(URI_API_VERSION, "v3");
    }

    public int getRefreshInterval() {
        return finalConfig.getInt(REFRESH_INTERVAL, 30000);
    }

    public int getFirstRefreshInterval() {
        return finalConfig.getInt(FIRST_REFRESH_INTERVAL, 0);
    }

    public Boolean isProxyEnable() {
        return finalConfig.getBoolean(PROXY_ENABLE, false);
    }

    public String getProxyHost() {
        return finalConfig.getString(PROXY_HOST, "127.0.0.1");
    }

    public int getProxyPort() {
        return finalConfig.getInt(PROXY_PORT, 8080);
    }

    public String getProxyUsername() {
        return finalConfig.getString(PROXY_USERNAME, null);
    }

    public String getProxyPasswd() {
        return finalConfig.getString(PROXY_PASSWD, null);
    }

    public String getServiceName() {
        Object o;
        String serviceVersion;
        String service = finalConfig.getString(SERVICE_NAME);
        String appName = finalConfig.getString(APPLICATION_NAME);
        if (appName != null) {
            service = service + "@" + appName;
        }
        if ((serviceVersion = finalConfig.getString(SERVICE_VERSION)) != null) {
            service = service + "#" + serviceVersion;
        }
        if ((o = finalConfig.getProperty(INSTANCE_TAGS)) == null) {
            return service;
        }
        String tags = o instanceof List ? Joiner.on((String)",").join((Iterable)((List)o)) : o.toString();
        service = service + "!" + tags;
        return service;
    }

    public List<String> getServerUri() {
        return Deployment.getSystemBootStrapInfo((String)"ConfigCenter").getAccessURL();
    }

    public boolean getAutoDiscoveryEnabled() {
        return finalConfig.getBoolean(AUTO_DISCOVERY_ENABLED, false);
    }

    public int getConnectionTimeout() {
        return finalConfig.getInt("servicecomb.config.client.timeout.connection", 30000);
    }

    public String getEnvironment() {
        return finalConfig.getString("service_description.environment", "");
    }
}

