/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.swagger.invocation.context;

import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.swagger.invocation.context.InvocationContext;
import org.apache.servicecomb.swagger.invocation.context.InvocationContextCompletableFuture;

public final class ContextUtils {
    private static ThreadLocal<InvocationContext> contextMgr = new ThreadLocal();

    private ContextUtils() {
    }

    public static InvocationContext getInvocationContext() {
        return contextMgr.get();
    }

    public static InvocationContext getAndRemoveInvocationContext() {
        InvocationContext context = contextMgr.get();
        if (context != null) {
            contextMgr.remove();
        }
        return context;
    }

    public static void setInvocationContext(InvocationContext invocationContext) {
        contextMgr.set(invocationContext);
    }

    public static void removeInvocationContext() {
        contextMgr.remove();
    }

    public static InvocationContext getFromCompletableFuture(CompletableFuture<?> future) {
        if (future instanceof InvocationContextCompletableFuture) {
            return ((InvocationContextCompletableFuture)future).getContext();
        }
        return null;
    }
}

