/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.spring.cloud.zuul;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.netflix.zuul.ZuulFilter;
import com.netflix.zuul.context.RequestContext;
import org.apache.servicecomb.config.ConfigUtil;
import org.apache.servicecomb.config.archaius.sources.MicroserviceConfigLoader;
import org.apache.servicecomb.foundation.common.utils.JsonUtils;
import org.apache.servicecomb.serviceregistry.definition.MicroserviceDefinition;
import org.springframework.stereotype.Component;

@Component
public class ContextHeaderZuulFilter
extends ZuulFilter {
    private static String microserviceName;

    public String filterType() {
        return "pre";
    }

    public int filterOrder() {
        return 0;
    }

    public boolean shouldFilter() {
        return true;
    }

    public Object run() {
        RequestContext ctx = RequestContext.getCurrentContext();
        ctx.addZuulRequestHeader("x-cse-src-microservice", microserviceName);
        this.saveHeadersAsInvocationContext(ctx);
        return null;
    }

    private void saveHeadersAsInvocationContext(RequestContext ctx) {
        try {
            ctx.addZuulRequestHeader("x-cse-context", JsonUtils.writeValueAsString((Object)ctx.getZuulRequestHeaders()));
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Unable to write request headers as json to x-cse-context", e);
        }
    }

    static {
        MicroserviceConfigLoader loader = ConfigUtil.getMicroserviceConfigLoader();
        MicroserviceDefinition microserviceDefinition = new MicroserviceDefinition(loader.getConfigModels());
        microserviceName = microserviceDefinition.getMicroserviceName();
    }
}

