/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.core.filter;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.servicecomb.core.filter.Filter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.config.InvocationFilterChainsConfig;
import org.apache.servicecomb.core.filter.config.TransportChainsConfig;
import org.apache.servicecomb.core.filter.impl.TransportFilters;

public class InvocationFilterChains {
    private final Map<String, Filter> filters = new HashMap<String, Filter>();
    private List<Object> resolvedFrameworkConfig;
    private List<Object> resolvedDefaultConfig;
    private final Map<String, List<Object>> resolvedMicroserviceConfig = new HashMap<String, List<Object>>();
    private FilterNode defaultChain;
    private final Map<String, FilterNode> microserviceChains = new HashMap<String, FilterNode>();

    public Collection<Filter> getFilters() {
        return this.filters.values();
    }

    public void addFilter(Filter filter) {
        this.filters.put(filter.getName(), filter);
    }

    public List<Object> getResolvedFrameworkConfig() {
        return this.resolvedFrameworkConfig;
    }

    public List<Object> getResolvedDefaultConfig() {
        return this.resolvedDefaultConfig;
    }

    public Map<String, List<Object>> getResolvedMicroserviceConfig() {
        return this.resolvedMicroserviceConfig;
    }

    public void resolve(Function<List<String>, List<Object>> resolver, InvocationFilterChainsConfig config) {
        this.resolvedFrameworkConfig = resolver.apply(config.getFrameworkChain());
        this.resolvedDefaultConfig = resolver.apply(config.getDefaultChain());
        this.defaultChain = this.createChain(this.resolvedDefaultConfig);
        for (Map.Entry<String, List<String>> entry : config.getMicroserviceChains().entrySet()) {
            List<Object> resolveConfig = resolver.apply(entry.getValue());
            this.resolvedMicroserviceConfig.put(entry.getKey(), resolveConfig);
            this.microserviceChains.put(entry.getKey(), this.createChain(resolveConfig));
        }
    }

    private <T> FilterNode createChain(List<T> chain) {
        List<Filter> filters = this.createFilters(chain);
        return FilterNode.buildChain(filters);
    }

    private <T> List<Filter> createFilters(List<T> chain) {
        return chain.stream().map(this::findFilter).collect(Collectors.toList());
    }

    private Filter findFilter(Object filterConfig) {
        if (filterConfig instanceof TransportChainsConfig) {
            return this.createTransportFilter((TransportChainsConfig)filterConfig);
        }
        Filter filter = this.filters.get(filterConfig);
        if (filter == null) {
            throw new IllegalStateException("failed to find filter, name=" + filterConfig);
        }
        return filter;
    }

    private Filter createTransportFilter(TransportChainsConfig config) {
        TransportFilters transportFilters = new TransportFilters();
        for (Map.Entry<String, List<String>> entry : config.getChainByTransport().entrySet()) {
            List<Filter> filters = this.createFilters(entry.getValue());
            transportFilters.getChainByTransport().put(entry.getKey(), FilterNode.buildChain(filters));
        }
        return transportFilters;
    }

    public FilterNode findChain(String microserviceName) {
        return this.microserviceChains.getOrDefault(microserviceName, this.defaultChain);
    }
}

