/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.codec.query;

import jakarta.servlet.http.HttpServletRequest;
import java.util.Collection;
import java.util.Map;
import org.apache.servicecomb.common.rest.codec.param.QueryProcessorCreator;
import org.apache.servicecomb.common.rest.codec.query.AbstractQueryCodec;
import org.apache.servicecomb.common.rest.codec.query.QueryCodec;
import org.apache.servicecomb.common.rest.definition.path.URLPathBuilder;

public class QueryCodecMulti
extends AbstractQueryCodec {
    public static final String CODEC_NAME = "form:1";

    public QueryCodecMulti() {
        super(CODEC_NAME);
    }

    @Override
    public void encode(URLPathBuilder.URLPathStringBuilder builder, String name, Collection<Object> values) throws Exception {
        for (Object value : values) {
            if (value == null) continue;
            String strValue = QueryCodec.convertToString(value);
            builder.appendQuery(name, QueryCodec.encodeValue(strValue));
        }
    }

    @Override
    public Object decode(QueryProcessorCreator.QueryProcessor processor, HttpServletRequest request) {
        if (processor.isRepeatedType()) {
            String[] values = request.getParameterValues(processor.getParameterPath());
            if (values == null || values.length == 0) {
                Map forms = (Map)request.getAttribute("servicecomb-body");
                if (forms == null) {
                    return processor.convertValue(values);
                }
                Object formValue = forms.get(processor.getParameterPath());
                if (formValue == null) {
                    return processor.convertValue(values);
                }
                values = formValue instanceof String[] ? (String[])formValue : new String[]{formValue.toString()};
            }
            return processor.convertValue(values);
        }
        Object value = processor.getAndCheckParameter(request);
        return processor.convertValue(value);
    }
}

