/*
 * Decompiled with CFR 0.152.
 */
package org.apache.servicecomb.common.rest.filter.inner;

import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.Part;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.servicecomb.common.rest.HttpTransportContext;
import org.apache.servicecomb.common.rest.codec.RestCodec;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessor;
import org.apache.servicecomb.common.rest.codec.produce.ProduceProcessorManager;
import org.apache.servicecomb.common.rest.definition.RestOperationMeta;
import org.apache.servicecomb.core.Invocation;
import org.apache.servicecomb.core.definition.OperationMeta;
import org.apache.servicecomb.core.exception.Exceptions;
import org.apache.servicecomb.core.filter.AbstractFilter;
import org.apache.servicecomb.core.filter.EdgeFilter;
import org.apache.servicecomb.core.filter.FilterNode;
import org.apache.servicecomb.core.filter.ProviderFilter;
import org.apache.servicecomb.foundation.common.utils.PartUtils;
import org.apache.servicecomb.foundation.vertx.http.HttpServletRequestEx;
import org.apache.servicecomb.foundation.vertx.http.HttpServletResponseEx;
import org.apache.servicecomb.foundation.vertx.stream.BufferOutputStream;
import org.apache.servicecomb.swagger.invocation.Response;
import org.apache.servicecomb.swagger.invocation.context.TransportContext;
import org.apache.servicecomb.swagger.invocation.exception.InvocationException;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestServerCodecFilter
extends AbstractFilter
implements ProviderFilter,
EdgeFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestServerCodecFilter.class);
    public static final String NAME = "rest-server-codec";

    public String getName() {
        return NAME;
    }

    public int getOrder() {
        return -2000;
    }

    public boolean enabledForTransport(String transport) {
        return "rest".equals(transport);
    }

    public CompletableFuture<Response> onFilter(Invocation invocation, FilterNode nextNode) {
        return ((CompletableFuture)((CompletableFuture)((CompletableFuture)CompletableFuture.completedFuture(invocation).thenAccept(this::decodeRequest)).thenCompose(v -> this.invokeNext(invocation, nextNode))).exceptionally(exception -> Exceptions.toProducerResponse((Invocation)invocation, (Throwable)exception))).thenCompose(response -> this.encodeResponse(invocation, (Response)response));
    }

    protected CompletableFuture<Response> invokeNext(Invocation invocation, FilterNode nextNode) {
        if (invocation.isEdge()) {
            TransportContext transportContext = invocation.getTransportContext();
            return nextNode.onFilter(invocation).whenComplete((r, e) -> invocation.setTransportContext(transportContext));
        }
        return nextNode.onFilter(invocation);
    }

    protected void decodeRequest(Invocation invocation) {
        invocation.getInvocationStageTrace().startProviderDecodeRequest();
        HttpServletRequestEx requestEx = invocation.getRequestEx();
        OperationMeta operationMeta = invocation.getOperationMeta();
        RestOperationMeta restOperationMeta = (RestOperationMeta)operationMeta.getExtData("swaggerRestOperation");
        Map<String, Object> swaggerArguments = RestCodec.restToArgs((HttpServletRequest)requestEx, restOperationMeta);
        invocation.setSwaggerArguments(swaggerArguments);
        invocation.getInvocationStageTrace().finishProviderDecodeRequest();
    }

    protected CompletableFuture<Response> encodeResponse(Invocation invocation, Response response) {
        invocation.onEncodeResponseStart(response);
        HttpTransportContext transportContext = (HttpTransportContext)invocation.getTransportContext();
        HttpServletResponseEx responseEx = transportContext.getResponseEx();
        ProduceProcessor produceProcessor = ProduceProcessorManager.INSTANCE.createProduceProcessor(invocation.getOperationMeta(), response.getStatusCode(), invocation.getRequestEx().getHeader("Accept"), null);
        return RestServerCodecFilter.encodeResponse(invocation, response, produceProcessor, responseEx).whenComplete((r, e) -> invocation.onEncodeResponseFinish());
    }

    private static boolean isFailedResponse(Response response) {
        return response.getResult() instanceof InvocationException;
    }

    private static CompletableFuture<Response> writePart(HttpServletResponseEx responseEx, Object data, Response response) {
        CompletableFuture<Response> result = new CompletableFuture<Response>();
        responseEx.sendPart(PartUtils.getSinglePart(null, (Object)data)).whenComplete((r, e) -> {
            if (e != null) {
                result.completeExceptionally((Throwable)e);
                return;
            }
            result.complete(response);
        });
        return result;
    }

    private static CompletableFuture<Response> writeResponse(HttpServletResponseEx responseEx, ProduceProcessor produceProcessor, Object data, Response response, boolean commit) {
        CompletableFuture<Response> completableFuture;
        BufferOutputStream output = new BufferOutputStream(Buffer.buffer());
        try {
            produceProcessor.encodeResponse((OutputStream)output, data);
            CompletableFuture<Response> result = new CompletableFuture<Response>();
            responseEx.setBodyBuffer(output.getBuffer());
            if (commit) {
                responseEx.setContentLength(output.getBuffer().length());
            }
            responseEx.sendBuffer(output.getBuffer()).whenComplete((v, e) -> {
                if (e != null) {
                    result.completeExceptionally((Throwable)e);
                    return;
                }
                if (!commit) {
                    try {
                        responseEx.flushBuffer();
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Failed to flush buffer for Server Send Events", (Throwable)ex);
                    }
                }
                result.complete(response);
            });
            completableFuture = result;
        }
        catch (Throwable throwable) {
            try {
                try {
                    output.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e2) {
                LOGGER.error("internal service error must be fixed.", e2);
                responseEx.setStatus(500);
                return CompletableFuture.failedFuture(e2);
            }
        }
        output.close();
        return completableFuture;
    }

    public static CompletableFuture<Response> encodeResponse(Invocation invocation, Response response, ProduceProcessor produceProcessor, HttpServletResponseEx responseEx) {
        responseEx.setStatus(response.getStatusCode());
        RestServerCodecFilter.copyHeadersToHttpResponse(invocation, response.getHeaders(), responseEx);
        if (RestServerCodecFilter.isFailedResponse(response)) {
            responseEx.setContentType(produceProcessor.getName());
            return RestServerCodecFilter.writeResponse(responseEx, produceProcessor, ((InvocationException)response.getResult()).getErrorData(), response, true);
        }
        if (RestServerCodecFilter.isDownloadFileResponseType(invocation, response)) {
            return RestServerCodecFilter.writePart(responseEx, response.getResult(), response);
        }
        if (RestServerCodecFilter.isServerSendEvent(response)) {
            responseEx.setContentType(produceProcessor.getName());
            return RestServerCodecFilter.writeServerSendEvent(response, produceProcessor, responseEx);
        }
        responseEx.setContentType(produceProcessor.getName());
        return RestServerCodecFilter.writeResponse(responseEx, produceProcessor, response.getResult(), response, true);
    }

    private static CompletableFuture<Response> writeServerSendEvent(final Response response, final ProduceProcessor produceProcessor, final HttpServletResponseEx responseEx) {
        responseEx.setChunked(true);
        final CompletableFuture<Response> result = new CompletableFuture<Response>();
        Publisher publisher = (Publisher)response.getResult();
        publisher.subscribe((Subscriber)new Subscriber<Object>(){
            Subscription subscription;

            public void onSubscribe(Subscription s) {
                s.request(1L);
                this.subscription = s;
            }

            public void onNext(Object o) {
                RestServerCodecFilter.writeResponse(responseEx, produceProcessor, o, response, false).whenComplete((r, e) -> {
                    if (e != null) {
                        this.subscription.cancel();
                        result.completeExceptionally((Throwable)e);
                        return;
                    }
                    this.subscription.request(1L);
                });
            }

            public void onError(Throwable t) {
                result.completeExceptionally(t);
            }

            public void onComplete() {
                result.complete(response);
            }
        });
        return result;
    }

    public static boolean isDownloadFileResponseType(Invocation invocation, Response response) {
        return Part.class.isAssignableFrom(invocation.findResponseType(response.getStatusCode()).getRawClass());
    }

    public static boolean isServerSendEvent(Response response) {
        return response.getResult() instanceof Publisher;
    }

    public static void copyHeadersToHttpResponse(Invocation invocation, MultiMap headers, HttpServletResponseEx responseEx) {
        if (headers != null) {
            headers.remove("Content-Length");
            headers.remove("Transfer-Encoding");
            for (Map.Entry entry : headers.entries()) {
                responseEx.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
        }
        if (invocation != null && responseEx.getHeader("X-B3-TraceId") == null) {
            responseEx.addHeader("X-B3-TraceId", invocation.getTraceId());
        }
    }
}

