/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.maven.javaversion;

import java.util.HashMap;
import java.util.Map;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="set-java-version", defaultPhase=LifecyclePhase.INITIALIZE)
public class SetJavaVersionMojo
extends AbstractMojo {
    @Parameter(property="sling.java.version")
    private String javaVersion;
    @Parameter(property="project", readonly=true, required=true)
    private MavenProject project;
    private final Map<String, String> javaVersionToBree = new HashMap<String, String>();

    public SetJavaVersionMojo() {
        this.javaVersionToBree.put("6", "JavaSE-1.6");
        this.javaVersionToBree.put("7", "JavaSE-1.7");
        this.javaVersionToBree.put("8", "JavaSE-1.8");
    }

    public void execute() throws MojoExecutionException {
        String bree = this.javaVersionToBree.get(this.javaVersion);
        if (bree == null) {
            throw new MojoExecutionException("Invalid javaVersion: " + this.javaVersion + ". Expected one of " + this.javaVersionToBree.keySet());
        }
        this.project.getProperties().setProperty("sling.bree", bree);
        this.project.getProperties().setProperty("sling.animalSignatures.version", this.javaVersion);
        this.getLog().info((CharSequence)("Setting Bundle-RequiredExecutionEnvironment=" + bree + " from sling.java.version=" + this.javaVersion));
    }
}

