/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.commons.classloader.impl;

import java.util.Hashtable;
import org.apache.sling.commons.classloader.DynamicClassLoaderManager;
import org.apache.sling.commons.classloader.impl.DynamicClassLoaderManagerFactory;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.BundleListener;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceRegistration;
import org.osgi.framework.SynchronousBundleListener;
import org.osgi.service.packageadmin.PackageAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements SynchronousBundleListener,
BundleActivator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private ServiceTracker<PackageAdmin, PackageAdmin> packageAdminTracker;
    private ServiceRegistration<DynamicClassLoaderManager> serviceReg;
    private DynamicClassLoaderManagerFactory service;
    private BundleContext bundleContext;

    public void start(BundleContext context) {
        this.bundleContext = context;
        this.packageAdminTracker = new ServiceTracker(this.bundleContext, PackageAdmin.class, null);
        this.packageAdminTracker.open();
        this.registerManagerFactory();
        this.bundleContext.addBundleListener((BundleListener)this);
    }

    protected void registerManagerFactory() {
        Hashtable<String, String> props = new Hashtable<String, String>();
        props.put("service.description", "Apache Sling Dynamic Class Loader Service");
        props.put("service.vendor", "The Apache Software Foundation");
        this.service = new DynamicClassLoaderManagerFactory(this.bundleContext, (PackageAdmin)this.packageAdminTracker.getService());
        this.serviceReg = this.bundleContext.registerService(DynamicClassLoaderManager.class, (ServiceFactory)this.service, props);
    }

    protected void unregisterManagerFactory() {
        if (this.serviceReg != null) {
            this.serviceReg.unregister();
            this.serviceReg = null;
        }
        if (this.service != null) {
            this.service = null;
        }
    }

    public void stop(BundleContext context) {
        context.removeBundleListener((BundleListener)this);
        this.unregisterManagerFactory();
        if (this.packageAdminTracker != null) {
            this.packageAdminTracker.close();
            this.packageAdminTracker = null;
        }
        this.bundleContext = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void bundleChanged(BundleEvent event) {
        Activator activator = this;
        synchronized (activator) {
            boolean reload;
            boolean lazyBundle;
            boolean bl = lazyBundle = event.getBundle().getHeaders().get("Bundle-ActivationPolicy") != null;
            if (event.getType() == 2 && !lazyBundle || event.getType() == 128 && lazyBundle) {
                if (this.service.hasUnresolvedPackages(event.getBundle())) {
                    reload = true;
                    this.logger.debug("Dynamic Class Loader is reloaded because the new bundle '{}' provides previously unresolved packages", (Object)event.getBundle());
                } else {
                    reload = false;
                }
            } else if (event.getType() == 64 || event.getType() == 32) {
                reload = this.service.isBundleUsed(event.getBundle().getBundleId());
                if (reload) {
                    this.logger.debug("Dynamic Class Loader is reloaded because it has previously loaded classes from bundle '{}' which is no longer active", (Object)event.getBundle());
                }
            } else {
                reload = false;
            }
            if (reload) {
                this.unregisterManagerFactory();
                this.registerManagerFactory();
            }
        }
    }
}

