/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.dynamicinclude;

import java.util.Collection;
import java.util.concurrent.CopyOnWriteArraySet;
import org.apache.sling.api.SlingHttpServletRequest;
import org.apache.sling.dynamicinclude.Configuration;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.FieldOption;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;

@Component(service={ConfigurationWhiteboard.class})
public class ConfigurationWhiteboard {
    @Reference(service=Configuration.class, cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC, fieldOption=FieldOption.UPDATE)
    private volatile Collection<Configuration> configs = new CopyOnWriteArraySet<Configuration>();

    public Configuration getConfiguration(SlingHttpServletRequest request, String resourceType) {
        for (Configuration c : this.configs) {
            if (!this.isEnabled(c, request) || !c.isSupportedResourceType(resourceType)) continue;
            return c;
        }
        return null;
    }

    private boolean isEnabled(Configuration config, SlingHttpServletRequest request) {
        String requestPath = request.getRequestPathInfo().getResourcePath();
        return config.isEnabled() && config.getPathMatcher().match(requestPath);
    }

    void bindConfigs(Configuration config) {
        this.configs.add(config);
    }
}

