/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.engine.impl.parameters;

import jakarta.servlet.ServletInputStream;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.RequestContext;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.apache.sling.api.request.RequestParameter;
import org.apache.sling.api.request.RequestParameterMap;
import org.apache.sling.engine.impl.parameters.ContainerRequestParameter;
import org.apache.sling.engine.impl.parameters.MultipartRequestParameter;
import org.apache.sling.engine.impl.parameters.ParameterMap;
import org.apache.sling.engine.impl.parameters.ParameterSupportHttpServletRequestWrapper;
import org.apache.sling.engine.impl.parameters.RequestPartsIterator;
import org.apache.sling.engine.impl.parameters.SlingUnsupportedEncodingException;
import org.apache.sling.engine.impl.parameters.Util;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParameterSupport {
    public static final String PARAMETER_FORMENCODING = "_charset_";
    public static final String MARKER_IS_SERVICE_PROCESSING = ParameterSupport.class.getName() + "/ServiceProcessingMarker";
    private static final String ATTR_NAME = ParameterSupport.class.getName();
    private static final String WWW_FORM_URL_ENC = "application/x-www-form-urlencoded";
    public static final String SLING_UPLOADMODE_HEADER = "Sling-uploadmode";
    public static final String UPLOADMODE_PARAM = "uploadmode";
    public static final String REQUEST_PARTS_ITERATOR_ATTRIBUTE = "request-parts-iterator";
    public static final String STREAM_UPLOAD = "stream";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private static long maxRequestSize = -1L;
    private static File location = null;
    private static long maxFileSize = -1L;
    private static int fileSizeThreshold = 256000;
    private static boolean checkForAdditionalParameters = false;
    private static long maxFileCount = 50L;
    private final HttpServletRequest servletRequest;
    private ParameterMap postParameterMap;
    private boolean requestDataUsed;

    public static ParameterSupport getInstance(HttpServletRequest request) {
        Object instance = request.getAttribute(ATTR_NAME);
        if (!(instance instanceof ParameterSupport)) {
            instance = new ParameterSupport(request);
            request.setAttribute(ATTR_NAME, instance);
        }
        return (ParameterSupport)instance;
    }

    public static HttpServletRequestWrapper getParameterSupportRequestWrapper(HttpServletRequest request) {
        return new ParameterSupportHttpServletRequestWrapper(request);
    }

    static void configure(long maxRequestSize, String location, long maxFileSize, int fileSizeThreshold, boolean checkForAdditionalParameters, long maxFileCount) {
        ParameterSupport.maxRequestSize = maxRequestSize > 0L ? maxRequestSize : -1L;
        ParameterSupport.location = location != null ? new File(location) : null;
        ParameterSupport.maxFileSize = maxFileSize > 0L ? maxFileSize : -1L;
        ParameterSupport.fileSizeThreshold = fileSizeThreshold > 0 ? fileSizeThreshold : 256000;
        ParameterSupport.checkForAdditionalParameters = checkForAdditionalParameters;
        ParameterSupport.maxFileCount = maxFileCount > 0L ? maxFileCount : 50L;
    }

    private ParameterSupport(HttpServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    private HttpServletRequest getServletRequest() {
        return this.servletRequest;
    }

    public boolean requestDataUsed() {
        return this.requestDataUsed;
    }

    public String getParameter(String name) {
        return this.getRequestParameterMapInternal().getStringValue(name);
    }

    public String[] getParameterValues(String name) {
        return this.getRequestParameterMapInternal().getStringValues(name);
    }

    public Map<String, String[]> getParameterMap() {
        return this.getRequestParameterMapInternal().getStringParameterMap();
    }

    public Enumeration<String> getParameterNames() {
        return new Enumeration<String>(){
            private final Iterator<String> base;
            {
                this.base = ParameterSupport.this.getRequestParameterMapInternal().keySet().iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.base.hasNext();
            }

            @Override
            public String nextElement() {
                return this.base.next();
            }
        };
    }

    public RequestParameter getRequestParameter(String name) {
        return this.getRequestParameterMapInternal().getValue(name);
    }

    public RequestParameter[] getRequestParameters(String name) {
        return this.getRequestParameterMapInternal().getValues(name);
    }

    public Object getPart(String name) {
        return this.getRequestParameterMapInternal().getPart(name);
    }

    public Collection<?> getParts() {
        return this.getRequestParameterMapInternal().getParts();
    }

    public RequestParameterMap getRequestParameterMap() {
        return this.getRequestParameterMapInternal();
    }

    public List<RequestParameter> getRequestParameterList() {
        return this.getRequestParameterMapInternal().getRequestParameterList();
    }

    private ParameterMap getRequestParameterMapInternal() {
        if (this.postParameterMap == null) {
            String encoding = this.getServletRequest().getCharacterEncoding();
            if (encoding == null) {
                encoding = "ISO-8859-1";
                try {
                    this.getServletRequest().setCharacterEncoding(encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    throw new SlingUnsupportedEncodingException(uee);
                }
            }
            ParameterMap parameters = new ParameterMap();
            boolean useFallback = this.getServletRequest().getAttribute(MARKER_IS_SERVICE_PROCESSING) != null;
            boolean addContainerParameters = false;
            String query = this.getServletRequest().getQueryString();
            if (query != null) {
                try {
                    InputStream input = Util.toInputStream(query);
                    Util.parseQueryString(input, encoding, parameters, false);
                    addContainerParameters = checkForAdditionalParameters;
                }
                catch (IllegalArgumentException e) {
                    this.log.error("getRequestParameterMapInternal: Error parsing request", (Throwable)e);
                }
                catch (UnsupportedEncodingException e) {
                    throw new SlingUnsupportedEncodingException(e);
                }
                catch (IOException e) {
                    this.log.error("getRequestParameterMapInternal: Error parsing request", (Throwable)e);
                }
                useFallback = false;
            } else {
                addContainerParameters = checkForAdditionalParameters;
                useFallback = true;
            }
            boolean isPost = "POST".equals(this.getServletRequest().getMethod());
            if (isPost) {
                if (ParameterSupport.isWWWFormEncodedContent(this.getServletRequest())) {
                    try {
                        ServletInputStream input = this.getServletRequest().getInputStream();
                        Util.parseQueryString((InputStream)input, encoding, parameters, false);
                        addContainerParameters = checkForAdditionalParameters;
                    }
                    catch (IllegalArgumentException e) {
                        this.log.error("getRequestParameterMapInternal: Error parsing request", (Throwable)e);
                    }
                    catch (UnsupportedEncodingException e) {
                        throw new SlingUnsupportedEncodingException(e);
                    }
                    catch (IOException e) {
                        this.log.error("getRequestParameterMapInternal: Error parsing request", (Throwable)e);
                    }
                    this.requestDataUsed = true;
                    useFallback = false;
                }
                if (ServletFileUpload.isMultipartContent((RequestContext)this.getMultiPartContext())) {
                    if (this.isStreamed(parameters, this.getServletRequest())) {
                        try {
                            this.getServletRequest().setAttribute(REQUEST_PARTS_ITERATOR_ATTRIBUTE, (Object)new RequestPartsIterator(this.getMultiPartContext()));
                            this.log.debug("getRequestParameterMapInternal: Iterator<javax.servlet.http.Part> available as request attribute named request-parts-iterator");
                        }
                        catch (IOException | FileUploadException e) {
                            this.log.error("getRequestParameterMapInternal: Error parsing multipart streamed request", e);
                        }
                        this.requestDataUsed = true;
                        addContainerParameters = false;
                        useFallback = false;
                    } else {
                        this.parseMultiPartPost(parameters);
                        this.requestDataUsed = true;
                        addContainerParameters = checkForAdditionalParameters;
                        useFallback = false;
                    }
                }
            }
            if (useFallback) {
                this.getContainerParameters(parameters, encoding, true);
            } else if (addContainerParameters) {
                this.getContainerParameters(parameters, encoding, false);
            }
            Util.fixEncoding(parameters);
            this.postParameterMap = parameters;
        }
        return this.postParameterMap;
    }

    private boolean isStreamed(ParameterMap parameters, HttpServletRequest servletRequest) {
        if (STREAM_UPLOAD.equals(servletRequest.getHeader(SLING_UPLOADMODE_HEADER))) {
            return true;
        }
        RequestParameter[] rp = (RequestParameter[])parameters.get(UPLOADMODE_PARAM);
        return rp != null && rp.length == 1 && STREAM_UPLOAD.equals(rp[0].getString());
    }

    private void getContainerParameters(ParameterMap parameters, String encoding, boolean alwaysAdd) {
        Map pMap = this.getServletRequest().getParameterMap();
        for (Map.Entry entry : pMap.entrySet()) {
            String name = (String)entry.getKey();
            if (!alwaysAdd && parameters.containsKey(name)) continue;
            String[] values = (String[])entry.getValue();
            for (int i = 0; i < values.length; ++i) {
                parameters.addParameter(new ContainerRequestParameter(name, values[i], encoding), false);
            }
        }
    }

    private static final boolean isWWWFormEncodedContent(HttpServletRequest request) {
        String contentType = request.getContentType();
        if (contentType == null) {
            return false;
        }
        return contentType.toLowerCase(Locale.ENGLISH).startsWith(WWW_FORM_URL_ENC);
    }

    private RequestContext getMultiPartContext() {
        return new RequestContext(){

            public String getCharacterEncoding() {
                String enc = ParameterSupport.this.getServletRequest().getCharacterEncoding();
                return enc != null ? enc : "ISO-8859-1";
            }

            public int getContentLength() {
                return ParameterSupport.this.getServletRequest().getContentLength();
            }

            public String getContentType() {
                return ParameterSupport.this.getServletRequest().getContentType();
            }

            public InputStream getInputStream() throws IOException {
                return ParameterSupport.this.getServletRequest().getInputStream();
            }
        };
    }

    private void parseMultiPartPost(ParameterMap parameters) {
        ServletFileUpload upload = new ServletFileUpload();
        upload.setSizeMax(maxRequestSize);
        upload.setFileSizeMax(maxFileSize);
        upload.setFileItemFactory((FileItemFactory)new DiskFileItemFactory(fileSizeThreshold, location));
        upload.setFileCountMax(maxFileCount);
        RequestContext rc = this.getMultiPartContext();
        List items = null;
        try {
            items = upload.parseRequest(rc);
        }
        catch (FileUploadException fue) {
            this.log.error("parseMultiPartPost: Error parsing request", (Throwable)fue);
        }
        if (items != null && items.size() > 0) {
            for (DiskFileItem fileItem : items) {
                MultipartRequestParameter pp = new MultipartRequestParameter(fileItem);
                parameters.addParameter(pp, false);
            }
        }
    }
}

