/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.featureflags.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.sling.api.request.ResponseUtil;
import org.apache.sling.featureflags.Feature;
import org.apache.sling.featureflags.Features;
import org.apache.sling.featureflags.impl.ExecutionContextImpl;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(service={Features.class, Filter.class, Servlet.class}, configurationPolicy=ConfigurationPolicy.IGNORE, property={"osgi.http.whiteboard.context.select=(osgi.http.whiteboard.context.name=org.apache.sling)", "osgi.http.whiteboard.filter.pattern=/", "felix.webconsole.label=features", "felix.webconsole.title=Features", "felix.webconsole.category=Sling", "service.ranking:Integer=16384", "service.vendor=The Apache Software Foundation"})
public class FeatureManager
implements Features,
Filter,
Servlet {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final ThreadLocal<ExecutionContextImpl> perThreadClientContext = new ThreadLocal();
    private final Map<String, List<FeatureDescription>> allFeatures = new HashMap<String, List<FeatureDescription>>();
    private Map<String, Feature> activeFeatures = Collections.emptyMap();
    private ServletConfig servletConfig;

    @Override
    public Feature[] getFeatures() {
        Map<String, Feature> activeFeatures = this.activeFeatures;
        return activeFeatures.values().toArray(new Feature[activeFeatures.size()]);
    }

    @Override
    public Feature getFeature(String name) {
        return this.activeFeatures.get(name);
    }

    @Override
    public boolean isEnabled(String featureName) {
        Feature feature = this.getFeature(featureName);
        if (feature != null) {
            return this.getCurrentExecutionContext().isEnabled(feature);
        }
        return false;
    }

    public void init(FilterConfig filterConfig) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.pushContext((HttpServletRequest)request);
        try {
            chain.doFilter(request, response);
        }
        finally {
            this.popContext();
        }
    }

    public void destroy() {
        this.servletConfig = null;
    }

    public void init(ServletConfig config) {
        this.servletConfig = config;
    }

    public ServletConfig getServletConfig() {
        return this.servletConfig;
    }

    public String getServletInfo() {
        return "Features";
    }

    public void service(ServletRequest req, ServletResponse res) throws IOException {
        if ("GET".equals(((HttpServletRequest)req).getMethod())) {
            PrintWriter pw = res.getWriter();
            Feature[] features = this.getFeatures();
            if (features == null || features.length == 0) {
                pw.println("<p class='statline ui-state-highlight'>No Features currently defined</p>");
            } else {
                pw.printf("<p class='statline ui-state-highlight'>%d Feature(s) currently defined</p>%n", features.length);
                pw.println("<table class='nicetable'>");
                pw.println("<tr><th>Name</th><th>Description</th><th>Enabled</th></tr>");
                ExecutionContextImpl ctx = this.getCurrentExecutionContext();
                for (Feature feature : features) {
                    pw.printf("<tr><td>%s</td><td>%s</td><td>%s</td></tr>%n", ResponseUtil.escapeXml((String)feature.getName()), ResponseUtil.escapeXml((String)feature.getDescription()), ctx.isEnabled(feature));
                }
                pw.println("</table>");
            }
        } else {
            ((HttpServletResponse)res).sendError(405);
            res.flushBuffer();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    private void bindFeature(Feature f, Map<String, Object> props) {
        Map<String, List<FeatureDescription>> map = this.allFeatures;
        synchronized (map) {
            String name = f.getName();
            FeatureDescription info = new FeatureDescription(f, props);
            List<FeatureDescription> candidates = this.allFeatures.get(name);
            if (candidates == null) {
                candidates = new ArrayList<FeatureDescription>();
                this.allFeatures.put(name, candidates);
            }
            candidates.add(info);
            Collections.sort(candidates);
            this.calculateActiveProviders();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unbindFeature(Feature f, Map<String, Object> props) {
        Map<String, List<FeatureDescription>> map = this.allFeatures;
        synchronized (map) {
            String name = f.getName();
            FeatureDescription info = new FeatureDescription(f, props);
            List<FeatureDescription> candidates = this.allFeatures.get(name);
            if (candidates != null) {
                candidates.remove(info);
                if (candidates.size() == 0) {
                    this.allFeatures.remove(name);
                }
            }
            this.calculateActiveProviders();
        }
    }

    private void calculateActiveProviders() {
        HashMap<String, Feature> activeMap = new HashMap<String, Feature>();
        for (Map.Entry<String, List<FeatureDescription>> entry : this.allFeatures.entrySet()) {
            FeatureDescription desc = entry.getValue().get(0);
            activeMap.put(entry.getKey(), desc.feature);
            if (entry.getValue().size() <= 1) continue;
            this.logger.warn("More than one feature service for feature {}", (Object)entry.getKey());
        }
        this.activeFeatures = activeMap;
    }

    void pushContext(HttpServletRequest request) {
        this.perThreadClientContext.set(new ExecutionContextImpl(this, request));
    }

    void popContext() {
        this.perThreadClientContext.set(null);
    }

    ExecutionContextImpl getCurrentExecutionContext() {
        ExecutionContextImpl ctx = this.perThreadClientContext.get();
        return ctx != null ? ctx : new ExecutionContextImpl(this, null);
    }

    private static final class FeatureDescription
    implements Comparable<FeatureDescription> {
        public final int ranking;
        public final long serviceId;
        public final Feature feature;

        public FeatureDescription(Feature feature, Map<String, Object> props) {
            this.feature = feature;
            Object sr = props.get("service.ranking");
            this.ranking = sr instanceof Integer ? (Integer)sr : 0;
            this.serviceId = (Long)props.get("service.id");
        }

        @Override
        public int compareTo(FeatureDescription o) {
            if (this.ranking < o.ranking) {
                return 1;
            }
            if (this.ranking > o.ranking) {
                return -1;
            }
            return this.serviceId < o.serviceId ? -1 : 1;
        }

        public boolean equals(Object obj) {
            if (obj instanceof FeatureDescription) {
                return ((FeatureDescription)obj).serviceId == this.serviceId;
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (int)(this.serviceId ^ this.serviceId >>> 32);
            return result;
        }
    }
}

