/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.ide.eclipse.m2e.internal;

import java.util.Set;
import org.apache.sling.ide.eclipse.core.ConfigurationHelper;
import org.apache.sling.ide.eclipse.m2e.internal.AbstractProjectConfigurator;
import org.apache.sling.ide.eclipse.m2e.internal.MavenProjectUtils;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.m2e.core.project.configurator.ProjectConfigurationRequest;

public class SlingFeatureProjectConfigurator
extends AbstractProjectConfigurator {
    public void configure(ProjectConfigurationRequest request, IProgressMonitor monitor) throws CoreException {
        IProject project = request.mavenProjectFacade().getProject();
        Set<String> candidates = MavenProjectUtils.getFeatureDirectoryCandidateLocations(request.mavenProject());
        IPath featuresPath = null;
        for (String candidate : candidates) {
            IPath candidatePath = Path.fromPortableString((String)candidate);
            IFolder featuresFolder = project.getFolder(candidatePath);
            if (!featuresFolder.exists()) continue;
            featuresPath = candidatePath;
            break;
        }
        SlingFeatureProjectConfigurator.trace("Configuring project {0} with features path {1}", project.getName(), featuresPath);
        ConfigurationHelper.convertToFeatureProject((IProject)project, featuresPath);
    }
}

