/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.util;

import java.util.Collection;
import java.util.List;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.core.impl.util.BundleRefresher;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkEvent;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.wiring.FrameworkWiring;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WABundleRefresher
implements BundleRefresher,
FrameworkListener {
    private final FrameworkWiring frameworkWiring;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final int MAX_REFRESH_PACKAGES_WAIT_SECONDS = 90;
    private volatile long refreshEventCount;
    private final Object lock = new Object();
    private final BundleContext bundleContext;

    public WABundleRefresher(FrameworkWiring wiring, BundleContext bundleContext) {
        this.frameworkWiring = wiring;
        this.bundleContext = bundleContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void refreshBundles(InstallationContext ctx, List<Bundle> bundles, boolean wait) {
        if (bundles == null || bundles.size() > 0) {
            if (bundles == null) {
                ctx.log("Full package refreshing", new Object[0]);
            } else {
                ctx.log("Refreshing {} bundles: {}", bundles.size(), bundles);
            }
            if (!wait) {
                this.frameworkWiring.refreshBundles(bundles == null ? null : bundles, new FrameworkListener[0]);
            } else {
                this.refreshEventCount = 0L;
                this.frameworkWiring.refreshBundles(bundles == null ? null : bundles, new FrameworkListener[]{this});
                long end = System.currentTimeMillis() + 90000L;
                do {
                    Object object = this.lock;
                    synchronized (object) {
                        long waitTime = end - System.currentTimeMillis();
                        if (this.refreshEventCount < 1L && waitTime > 0L) {
                            try {
                                ctx.log("Waiting up to {} seconds for bundles refresh", 90);
                                this.lock.wait(waitTime);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                            if (end <= System.currentTimeMillis() && this.refreshEventCount < 1L) {
                                this.logger.warn("No FrameworkEvent.PACKAGES_REFRESHED event received within {} seconds after refresh, aborting wait.", (Object)90);
                                ++this.refreshEventCount;
                            }
                        }
                    }
                } while (this.refreshEventCount < 1L);
            }
            if (bundles == null) {
                ctx.log("Done full package refresh", new Object[0]);
            } else {
                ctx.log("Done refreshing {} bundles", bundles.size());
            }
        }
    }

    @Override
    public boolean isInstallerBundleAffected(List<Bundle> bundles) {
        long installerId = this.bundleContext.getBundle().getBundleId();
        Collection dependencyClosure = this.frameworkWiring.getDependencyClosure(bundles);
        for (Bundle b : dependencyClosure) {
            if (b.getBundleId() != installerId) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void frameworkEvent(FrameworkEvent event) {
        if (event.getType() == 4) {
            this.logger.debug("FrameworkEvent.PACKAGES_REFRESHED");
            Object object = this.lock;
            synchronized (object) {
                ++this.refreshEventCount;
                this.lock.notify();
            }
        }
    }
}

