/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.launchpad.app;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.sling.launchpad.app.ControlAction;
import org.apache.sling.launchpad.app.ControlListener;
import org.apache.sling.launchpad.base.shared.Launcher;
import org.apache.sling.launchpad.base.shared.Loader;
import org.apache.sling.launchpad.base.shared.Notifiable;

public class Main {
    private static final String ENV_SLING_HOME = "SLING_HOME";
    protected static final String PROP_CONTROL_ACTION = "sling.control.action";
    protected static final String PROP_CONTROL_SOCKET = "sling.control.socket";
    private static final String PROP_LOG_LEVEL = "org.apache.sling.commons.log.level";
    private static final String PROP_LOG_FILE = "org.apache.sling.commons.log.file";
    private static final String PROP_PORT = "org.osgi.service.http.port";
    private static final String PROP_CONTEXT_PATH = "org.apache.felix.http.context_path";
    private static final String PROP_HOST = "org.apache.felix.http.host";
    private static final String PROP_SHUTDOWN_HOOK = "sling.shutdown.hook";
    private final Map<String, String> commandLineArgs;
    private boolean installShutdownHook;
    private Thread shutdownHook;
    private final String slingHome;
    private Loader loader;
    private Launcher sling;
    private boolean started = false;
    private static final DateFormat fmt = new SimpleDateFormat("dd.MM.yyyy HH:mm:ss.SSS ");

    public static void main(String[] args) {
        Main main;
        int rc;
        Map<String, String> props;
        Map<String, String> rawArgs = Main.parseCommandLine(args);
        if (Main.doHelp(rawArgs)) {
            System.exit(0);
        }
        if ((props = Main.convertCommandLineArgs(rawArgs)) == null) {
            System.exit(1);
        }
        if ((rc = (main = new Main(props)).doControlAction()) >= 0) {
            main.terminateVM(rc);
        }
        if (!main.doStart()) {
            Main.error("Failed to start Sling; terminating", null);
            main.terminateVM(1);
        }
    }

    protected Main(Map<String, String> args) {
        this.commandLineArgs = args == null ? new HashMap() : args;
        this.installShutdownHook = Main.installShutdownHook(this.commandLineArgs);
        String home = Main.getSlingHome(this.commandLineArgs);
        File slingHomeFile = new File(home);
        if (!slingHomeFile.isAbsolute()) {
            home = slingHomeFile.getAbsolutePath();
        }
        this.slingHome = home;
    }

    protected int doControlAction() {
        ControlAction action = this.getControlAction();
        if (action != null) {
            ControlListener sl = new ControlListener(this, this.commandLineArgs.remove(PROP_CONTROL_SOCKET));
            switch (action) {
                case START: {
                    if (sl.listen()) break;
                    return 0;
                }
                case STATUS: {
                    return sl.statusServer();
                }
                case STOP: {
                    return sl.shutdownServer();
                }
                case THREADS: {
                    return sl.dumpThreads();
                }
            }
        }
        return -1;
    }

    void terminateVM(int status) {
        System.exit(status);
    }

    private ControlAction getControlAction() {
        String action = this.commandLineArgs.remove(PROP_CONTROL_ACTION);
        if (action != null) {
            if (action instanceof ControlAction) {
                return (ControlAction)((Object)action);
            }
            try {
                return ControlAction.valueOf(action.toString().toUpperCase());
            }
            catch (IllegalArgumentException iae) {
                Main.error("Illegal control action value: " + action, null);
            }
        }
        return null;
    }

    protected boolean doStart() {
        return this.doStart(this.getClass().getResource("/resources/org.apache.sling.launchpad.base.jar"));
    }

    protected boolean doStart(URL launcherJar) {
        if (this.started) {
            Main.info("Apache Sling has already been started", null);
            return true;
        }
        Main.info("Starting Apache Sling in " + this.slingHome, null);
        this.started = true;
        Loader loaderTmp = null;
        try {
            File launchpadHome = Main.getLaunchpadHome(this.slingHome, this.commandLineArgs);
            loaderTmp = new Loader(launchpadHome){

                @Override
                protected void info(String msg) {
                    Main.info(msg, null);
                }
            };
        }
        catch (IllegalArgumentException iae) {
            Main.error("Cannot launch: Launchpad folder cannot be used: " + iae.getMessage(), null);
            return false;
        }
        this.loader = loaderTmp;
        if (launcherJar != null) {
            try {
                this.loader.installLauncherJar(launcherJar);
            }
            catch (IOException ioe) {
                Main.error("Cannot launch: Cannot install " + launcherJar + " for use", ioe);
                return false;
            }
        } else {
            Main.info("No Launcher JAR to install", null);
        }
        Object object = null;
        try {
            object = this.loader.loadLauncher("org.apache.sling.launchpad.base.app.MainDelegate");
        }
        catch (IllegalArgumentException iae) {
            Main.error("Cannot launch: Failed loading Sling class org.apache.sling.launchpad.base.app.MainDelegate", iae);
            return false;
        }
        if (object instanceof Launcher) {
            Launcher sling = (Launcher)object;
            sling.setNotifiable(new Notified());
            sling.setCommandLine(this.commandLineArgs);
            sling.setSlingHome(this.slingHome);
            Main.info("Starting launcher ...", null);
            if (sling.start()) {
                Main.info("Startup completed", null);
                this.sling = sling;
                this.addShutdownHook();
                return true;
            }
            Main.error("Cannot launch: Launcher.start() returned false", null);
        } else {
            Main.error("Cannot launch: Class org.apache.sling.launchpad.base.app.MainDelegate is not a Launcher class", null);
        }
        return false;
    }

    protected void doStop() {
        this.removeShutdownHook();
        if (this.sling != null) {
            Main.info("Stopping Apache Sling", null);
            this.sling.stop();
            this.sling = null;
        }
        if (this.loader != null) {
            this.loader.cleanupVM();
            this.loader = null;
        }
        this.started = false;
    }

    private void addShutdownHook() {
        if (this.installShutdownHook && this.shutdownHook == null) {
            this.shutdownHook = new Thread((Runnable)new ShutdownHook(), "Apache Sling Terminator");
            Runtime.getRuntime().addShutdownHook(this.shutdownHook);
        }
    }

    private void removeShutdownHook() {
        Thread shutdownHook = this.shutdownHook;
        this.shutdownHook = null;
        if (shutdownHook != null) {
            try {
                Runtime.getRuntime().removeShutdownHook(shutdownHook);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String getSlingHome(Map<String, String> commandLine) {
        String source = null;
        String slingHome = commandLine.get("sling.home");
        if (slingHome != null) {
            source = "command line";
        } else {
            slingHome = System.getProperty("sling.home");
            if (slingHome != null) {
                source = "system property sling.home";
            } else {
                slingHome = System.getenv(ENV_SLING_HOME);
                if (slingHome != null) {
                    source = "environment variable SLING_HOME";
                } else {
                    source = "default";
                    slingHome = "sling";
                }
            }
        }
        Main.info("Setting sling.home=" + slingHome + " (" + source + ")", null);
        return slingHome;
    }

    public String getSlingHome() {
        return this.slingHome;
    }

    private static File getLaunchpadHome(String slingHome, Map<String, String> commandLineArgs) {
        String launchpadHomeParam = commandLineArgs.get("sling.launchpad");
        if (launchpadHomeParam == null || launchpadHomeParam.length() == 0) {
            commandLineArgs.put("sling.launchpad", slingHome);
            return new File(slingHome);
        }
        File launchpadHome = new File(launchpadHomeParam);
        if (!launchpadHome.isAbsolute()) {
            launchpadHome = new File(slingHome, launchpadHomeParam);
        }
        commandLineArgs.put("sling.launchpad", launchpadHome.getAbsolutePath());
        return launchpadHome;
    }

    protected static void info(String message, Throwable t) {
        Main.log(System.out, "*INFO *", message, t);
    }

    protected static void error(String message, Throwable t) {
        Main.log(System.err, "*ERROR*", message, t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void log(PrintStream out, String prefix, String message, Throwable t) {
        StringBuilder linePrefixBuilder = new StringBuilder();
        DateFormat dateFormat = fmt;
        synchronized (dateFormat) {
            linePrefixBuilder.append(fmt.format(new Date()));
        }
        linePrefixBuilder.append(prefix);
        linePrefixBuilder.append(" [");
        linePrefixBuilder.append(Thread.currentThread().getName());
        linePrefixBuilder.append("] ");
        final String linePrefix = linePrefixBuilder.toString();
        out.print(linePrefix);
        out.println(message);
        if (t != null) {
            t.printStackTrace(new PrintStream((OutputStream)out){

                @Override
                public void print(String x) {
                    super.print(linePrefix);
                    super.print(x);
                }
            });
        }
    }

    static Map<String, String> parseCommandLine(String ... args) {
        HashMap<String, String> commandLine = new HashMap<String, String>();
        boolean readUnparsed = false;
        for (int argc = 0; args != null && argc < args.length; ++argc) {
            String arg = args[argc];
            if (readUnparsed) {
                commandLine.put(arg, arg);
                continue;
            }
            if (arg.startsWith("-")) {
                String val;
                int indexOfEq;
                if (arg.length() == 1) {
                    readUnparsed = true;
                    continue;
                }
                String key = String.valueOf(arg.charAt(1));
                if (arg.length() > 2) {
                    indexOfEq = arg.indexOf(61);
                    if (indexOfEq != -1) {
                        key = arg.substring(1, indexOfEq);
                        val = arg.substring(indexOfEq + 1);
                    } else {
                        val = arg.substring(2);
                    }
                    commandLine.put(key, val);
                    continue;
                }
                if (++argc < args.length && (args[argc].equals("-") || !args[argc].startsWith("-"))) {
                    val = args[argc];
                    if (key.equals("D") && (indexOfEq = val.indexOf(61)) != -1) {
                        key = "D" + val.substring(0, indexOfEq);
                        val = val.substring(indexOfEq + 1);
                    }
                    commandLine.put(key, val);
                    continue;
                }
                commandLine.put(key, key);
                --argc;
                continue;
            }
            commandLine.put(arg, arg);
        }
        return commandLine;
    }

    private static boolean doHelp(Map<String, String> args) {
        if (args.remove("h") != null) {
            System.out.println("usage: " + Main.class.getName() + " [ start | stop | status ] [ -j adr ] [ -l loglevel ] [ -f logfile ] [ -c slinghome ] [ -i launchpadhome ] [ -a address ] [ -p port ] { -Dn=v } [ -h ]");
            System.out.println("    start         listen for control connection (uses -j)");
            System.out.println("    stop          terminate running Apache Sling (uses -j)");
            System.out.println("    status        check whether Apache Sling is running (uses -j)");
            System.out.println("    threads       request a thread dump from Apache Sling (uses -j)");
            System.out.println("    -j adr        host and port to use for control connection in the format '[host:]port' (default 127.0.0.1:0)");
            System.out.println("    -l loglevel   the initial loglevel (0..4, FATAL, ERROR, WARN, INFO, DEBUG)");
            System.out.println("    -f logfile    the log file, \"-\" for stdout (default logs/error.log)");
            System.out.println("    -c slinghome  the sling context directory (default sling)");
            System.out.println("    -i launchpadhome  the launchpad directory (default slinghome)");
            System.out.println("    -a address    the interfact to bind to (use 0.0.0.0 for any)");
            System.out.println("    -p port       the port to listen to (default 8080)");
            System.out.println("    -r path       the root servlet context path for the http service (default is /)");
            System.out.println("    -n            don't install the shutdown hook");
            System.out.println("    -Dn=v         sets property n to value v. Make sure to use this option *after* the jar filename. The JVM also has a -D option which has a different meaning");
            System.out.println("    -h            prints this usage message");
            return true;
        }
        return false;
    }

    private static boolean installShutdownHook(Map<String, String> props) {
        String prop = props.remove(PROP_SHUTDOWN_HOOK);
        if (prop == null) {
            prop = System.getProperty(PROP_SHUTDOWN_HOOK);
        }
        return prop == null ? true : Boolean.valueOf(prop);
    }

    static Map<String, String> convertCommandLineArgs(Map<String, String> rawArgs) {
        HashMap<String, String> props = new HashMap<String, String>();
        boolean errorArg = false;
        block14: for (Map.Entry<String, String> arg : rawArgs.entrySet()) {
            if (arg.getKey().length() == 1 || arg.getKey().startsWith("D")) {
                String value = arg.getValue();
                switch (arg.getKey().charAt(0)) {
                    case 'j': {
                        if (value == arg.getKey()) {
                            Main.errorArg("-j", "Missing host:port value");
                            errorArg = true;
                            continue block14;
                        }
                        props.put(PROP_CONTROL_SOCKET, value);
                        break;
                    }
                    case 'l': {
                        if (value == arg.getKey()) {
                            Main.errorArg("-l", "Missing log level value");
                            errorArg = true;
                            continue block14;
                        }
                        props.put(PROP_LOG_LEVEL, value);
                        break;
                    }
                    case 'f': {
                        if (value == arg.getKey()) {
                            Main.errorArg("-f", "Missing log file value");
                            errorArg = true;
                            continue block14;
                        }
                        if ("-".equals(value)) {
                            value = "";
                        }
                        props.put(PROP_LOG_FILE, value);
                        break;
                    }
                    case 'c': {
                        if (value == arg.getKey()) {
                            Main.errorArg("-c", "Missing directory value");
                            errorArg = true;
                            continue block14;
                        }
                        props.put("sling.home", value);
                        break;
                    }
                    case 'i': {
                        if (value == arg.getKey()) {
                            Main.errorArg("-i", "Missing launchpad directory value");
                            errorArg = true;
                            continue block14;
                        }
                        props.put("sling.launchpad", value);
                        break;
                    }
                    case 'a': {
                        if (value == arg.getKey()) {
                            Main.errorArg("-a", "Missing address value");
                            errorArg = true;
                            continue block14;
                        }
                        props.put(PROP_HOST, value);
                        break;
                    }
                    case 'p': {
                        if (value == arg.getKey()) {
                            Main.errorArg("-p", "Missing port value");
                            errorArg = true;
                            continue block14;
                        }
                        try {
                            Integer.parseInt(value);
                            props.put(PROP_PORT, value);
                        }
                        catch (RuntimeException e) {
                            Main.errorArg("-p", "Bad port: " + value);
                            errorArg = true;
                        }
                        break;
                    }
                    case 'r': {
                        if (value == arg.getKey()) {
                            Main.errorArg("-r", "Missing root path value");
                            errorArg = true;
                            continue block14;
                        }
                        props.put(PROP_CONTEXT_PATH, value);
                        break;
                    }
                    case 'n': {
                        props.put(PROP_SHUTDOWN_HOOK, Boolean.FALSE.toString());
                        break;
                    }
                    case 'D': {
                        if (value == arg.getKey()) {
                            Main.errorArg("-D", "Missing property assignment");
                            errorArg = true;
                            continue block14;
                        }
                        if (arg.getKey().length() > 1) {
                            props.put(arg.getKey().substring(1), arg.getValue());
                            break;
                        }
                        String[] parts = value.split("=");
                        int valueIdx = parts.length > 1 ? 1 : 0;
                        props.put(parts[0], parts[valueIdx]);
                        break;
                    }
                    default: {
                        Main.errorArg("-" + arg.getKey(), "Unrecognized option");
                        errorArg = true;
                        break;
                    }
                }
                continue;
            }
            if ("start".equals(arg.getKey()) || "stop".equals(arg.getKey()) || "status".equals(arg.getKey()) || "threads".equals(arg.getKey())) {
                props.put(PROP_CONTROL_ACTION, arg.getValue());
                continue;
            }
            Main.errorArg(arg.getKey(), "Unrecognized option");
            errorArg = true;
        }
        return errorArg ? null : props;
    }

    private static void errorArg(String option, String message) {
        Main.error(String.format("%s: %s (use -h for more information)", option, message), null);
    }

    static void cleanupThreads() {
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        Thread[] active = new Thread[tg.activeCount()];
        tg.enumerate(active);
        for (Thread thread : active) {
            if (thread == null) continue;
            if (thread.getName().equals("FileCleaningTracker$Reaper")) {
                thread.stop();
                continue;
            }
            ClassLoader loader = thread.getContextClassLoader();
            if (loader == null || !loader.getClass().getName().startsWith("org.apache.felix.framework.")) continue;
            thread.setContextClassLoader(null);
        }
        ThreadGroup[] groups = new ThreadGroup[tg.activeGroupCount()];
        tg.enumerate(groups);
        for (ThreadGroup group : groups) {
            if (group == null || !group.getName().equals("QuartzScheduler:ApacheSling")) continue;
            group.destroy();
        }
    }

    private class Notified
    implements Notifiable {
        private Notified() {
        }

        @Override
        public void stopped() {
            Main.info("Apache Sling has been stopped", null);
            Main.this.sling = null;
            Main.this.doStop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void updated(File updateFile) {
            Main.this.sling = null;
            Main.this.doStop();
            Main.cleanupThreads();
            if (updateFile == null) {
                Main.info("Restarting Framework and Apache Sling", null);
                if (!Main.this.doStart(null)) {
                    Main.error("Failed to restart Sling; terminating", null);
                    Main.this.terminateVM(1);
                }
            } else {
                Main.info("Restarting Framework with update from " + updateFile, null);
                boolean started = false;
                try {
                    started = Main.this.doStart(updateFile.toURI().toURL());
                }
                catch (MalformedURLException mue) {
                    Main.error("Cannot get URL for file " + updateFile, mue);
                }
                finally {
                    updateFile.delete();
                }
                if (!started) {
                    Main.error("Failed to restart Sling; terminating", null);
                    Main.this.terminateVM(1);
                }
            }
        }
    }

    private class ShutdownHook
    implements Runnable {
        private ShutdownHook() {
        }

        @Override
        public void run() {
            Main.info("Java VM is shutting down", null);
            Main.this.doStop();
        }
    }
}

