/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.models.impl;

import java.util.Arrays;
import java.util.Map;
import javax.inject.Inject;
import org.apache.sling.api.SlingJakartaHttpServletRequest;
import org.apache.sling.api.scripting.SlingBindings;
import org.apache.sling.models.annotations.Model;
import org.apache.sling.models.annotations.Source;
import org.apache.sling.models.factory.ModelClassException;
import org.apache.sling.models.impl.AdapterFactoryTest;
import org.apache.sling.models.impl.ModelAdapterFactory;
import org.apache.sling.models.impl.ServicePropertiesMap;
import org.apache.sling.models.impl.injectors.BindingsInjector;
import org.apache.sling.models.impl.injectors.RequestAttributeInjector;
import org.apache.sling.models.spi.injectorspecific.StaticInjectAnnotationProcessorFactory;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(value={MockitoExtension.class})
class MultipleInjectorTest {
    @Spy
    private BindingsInjector bindingsInjector;
    @Spy
    private RequestAttributeInjector attributesInjector;
    @Mock
    private SlingJakartaHttpServletRequest request;
    private ModelAdapterFactory factory;
    private SlingBindings bindings;

    MultipleInjectorTest() {
    }

    @BeforeEach
    void setup() {
        this.bindings = new SlingBindings();
        this.factory = AdapterFactoryTest.createModelAdapterFactory();
        this.factory.injectors = Arrays.asList(this.bindingsInjector, this.attributesInjector);
        this.factory.bindStaticInjectAnnotationProcessorFactory((StaticInjectAnnotationProcessorFactory)this.bindingsInjector, (Map)new ServicePropertiesMap(1L, 1));
        Mockito.lenient().when(this.request.getAttribute(SlingBindings.class.getName())).thenReturn((Object)this.bindings);
        this.factory.adapterImplementations.addClassesAsAdapterAndImplementation(new Class[]{ForTwoInjectorsWithSource.class, ForTwoInjectors.class, ForTwoInjectorsWithInvalidSource.class});
    }

    @Test
    void testInjectorOrder() {
        String bindingsValue = "bindings value";
        this.bindings.put("firstAttribute", (Object)bindingsValue);
        String attributeValue = "attribute value";
        Mockito.lenient().when(this.request.getAttribute("firstAttribute")).thenReturn((Object)attributeValue);
        ForTwoInjectors obj = (ForTwoInjectors)this.factory.getAdapter((Object)this.request, ForTwoInjectors.class);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertEquals((Object)obj.firstAttribute, (Object)bindingsValue);
    }

    @Test
    void testInjectorOrderWithSource() {
        String bindingsValue = "bindings value";
        this.bindings.put("firstAttribute", (Object)bindingsValue);
        String attributeValue = "attribute value";
        Mockito.lenient().when(this.request.getAttribute("firstAttribute")).thenReturn((Object)attributeValue);
        ForTwoInjectorsWithSource obj = (ForTwoInjectorsWithSource)this.factory.getAdapter((Object)this.request, ForTwoInjectorsWithSource.class);
        Assertions.assertNotNull((Object)obj);
        Assertions.assertEquals((Object)obj.firstAttribute, (Object)attributeValue);
    }

    @Test
    void testInjectorWithInvalidSource() {
        ForTwoInjectorsWithInvalidSource obj = (ForTwoInjectorsWithInvalidSource)this.factory.getAdapter((Object)this.request, ForTwoInjectorsWithInvalidSource.class);
        Assertions.assertNull((Object)obj);
    }

    @Test
    void testInjectorWithInvalidSourceWithException() {
        Assert.assertThrows(ModelClassException.class, () -> this.factory.createModel((Object)this.request, ForTwoInjectorsWithInvalidSource.class));
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class})
    public static class ForTwoInjectorsWithSource {
        @Inject
        @Source(value="request-attributes")
        private String firstAttribute;
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class})
    public static class ForTwoInjectors {
        @Inject
        private String firstAttribute;
    }

    @Model(adaptables={SlingJakartaHttpServletRequest.class})
    public static class ForTwoInjectorsWithInvalidSource {
        @Inject
        @Source(value="this-is-an-invalid-source")
        private String firstAttribute;
    }
}

