/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.bundle.tracker.internal;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.sling.scripting.bundle.tracker.internal.Executable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractBundledRenderUnit
implements Executable {
    private static final Logger LOG = LoggerFactory.getLogger((String)AbstractBundledRenderUnit.class.getName());
    private final Bundle bundle;
    private final BundleContext bundleContext;
    private List<ServiceReference> references;
    private Map<String, Object> services;

    AbstractBundledRenderUnit(@NotNull Bundle bundle) {
        this.bundle = bundle;
        this.bundleContext = bundle.getBundleContext();
    }

    @Override
    @NotNull
    public Bundle getBundle() {
        return this.bundle;
    }

    @Override
    @Nullable
    public <ServiceType> ServiceType getService(@NotNull String className) {
        ServiceReference ref;
        Object result;
        LOG.debug("Attempting to load class {} as an OSGi service.", (Object)className);
        Object object = result = this.services == null ? null : this.services.get(className);
        if (result == null && (ref = this.bundleContext.getServiceReference(className)) != null && (result = this.bundleContext.getService(ref)) != null) {
            if (this.services == null) {
                this.services = new HashMap<String, Object>();
            }
            if (this.references == null) {
                this.references = new ArrayList<ServiceReference>();
            }
            this.references.add(ref);
            this.services.put(className, result);
            return (ServiceType)result;
        }
        return null;
    }

    @Override
    @Nullable
    public <ServiceType> ServiceType[] getServices(@NotNull String className, @Nullable String filter) {
        Object[] result = null;
        try {
            ServiceReference[] refs = this.bundleContext.getServiceReferences(className, filter);
            if (refs != null) {
                List<ServiceReference> references = Arrays.asList(refs);
                Collections.sort(references);
                Collections.reverse(references);
                ArrayList<Object> objects = new ArrayList<Object>();
                for (ServiceReference reference : references) {
                    Object service = this.bundleContext.getService(reference);
                    if (service == null) continue;
                    if (this.references == null) {
                        this.references = new ArrayList<ServiceReference>();
                    }
                    this.references.add(reference);
                    objects.add(service);
                }
                if (objects.size() > 0) {
                    Object[] srv = (Object[])Array.newInstance(this.bundle.loadClass(className), objects.size());
                    result = objects.toArray(srv);
                }
            }
        }
        catch (Exception e) {
            LOG.error(String.format("Unable to retrieve the services of type %s.", className), (Throwable)e);
        }
        return result;
    }

    @Override
    public void releaseDependencies() {
        if (this.references != null) {
            for (ServiceReference reference : this.references) {
                this.bundleContext.ungetService(reference);
            }
            this.references.clear();
        }
        if (this.services != null) {
            this.services.clear();
        }
    }
}

