/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.console.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.Iterator;
import org.apache.sling.api.resource.AbstractResource;
import org.apache.sling.api.resource.Resource;
import org.apache.sling.api.resource.ResourceMetadata;
import org.apache.sling.api.resource.ResourceResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class RuntimeScriptResource
extends AbstractResource
implements Resource {
    private ResourceMetadata metadata = new ResourceMetadata();
    private final String path;
    private final byte[] scriptContent;

    public RuntimeScriptResource(String extension, String scriptText) {
        this.scriptContent = this.getScriptContent(scriptText);
        this.path = "script." + extension;
    }

    public <AdapterType> AdapterType adaptTo(Class<AdapterType> type) {
        if (InputStream.class.isAssignableFrom(type)) {
            return (AdapterType)new ByteArrayInputStream(this.scriptContent);
        }
        return (AdapterType)super.adaptTo(type);
    }

    public String getPath() {
        return this.path;
    }

    public String getName() {
        return "script";
    }

    public Resource getParent() {
        return null;
    }

    public Iterator<Resource> listChildren() {
        return Collections.emptyList().iterator();
    }

    public Resource getChild(String relPath) {
        return null;
    }

    public String getResourceType() {
        return "sling:nonexisting";
    }

    public String getResourceSuperType() {
        return null;
    }

    public boolean isResourceType(String resourceType) {
        return false;
    }

    public ResourceMetadata getResourceMetadata() {
        return this.metadata;
    }

    public ResourceResolver getResourceResolver() {
        return null;
    }

    private byte[] getScriptContent(String scriptText) {
        try {
            return scriptText.getBytes("utf-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }
}

