/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.scripting.sightly.java.compiler.impl;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import org.apache.sling.scripting.sightly.compiler.commands.CommandVisitor;
import org.apache.sling.scripting.sightly.compiler.commands.Conditional;
import org.apache.sling.scripting.sightly.compiler.commands.Loop;
import org.apache.sling.scripting.sightly.compiler.commands.OutText;
import org.apache.sling.scripting.sightly.compiler.commands.OutputVariable;
import org.apache.sling.scripting.sightly.compiler.commands.Procedure;
import org.apache.sling.scripting.sightly.compiler.commands.StatefulVisitor;
import org.apache.sling.scripting.sightly.compiler.commands.VariableBinding;
import org.apache.sling.scripting.sightly.java.compiler.impl.ExpressionTranslator;
import org.apache.sling.scripting.sightly.java.compiler.impl.JavaSource;
import org.apache.sling.scripting.sightly.java.compiler.impl.Type;
import org.apache.sling.scripting.sightly.java.compiler.impl.TypeInference;
import org.apache.sling.scripting.sightly.java.compiler.impl.TypeInfo;
import org.apache.sling.scripting.sightly.java.compiler.impl.UnitBuilder;
import org.apache.sling.scripting.sightly.java.compiler.impl.VariableAnalyzer;
import org.apache.sling.scripting.sightly.java.compiler.impl.VariableDescriptor;
import org.apache.sling.scripting.sightly.java.compiler.impl.VariableScope;

public class CodeGenVisitor
implements CommandVisitor {
    private final JavaSource source;
    private final UnitBuilder unitBuilder;
    private final Stack<String> loopStatusStack = new Stack();
    private final VariableAnalyzer analyzer = new VariableAnalyzer();
    private final StatefulVisitor.StateControl control;
    private final Set<String> unitParameters;

    public CodeGenVisitor(UnitBuilder unitBuilder, StatefulVisitor.StateControl control) {
        this.unitBuilder = unitBuilder;
        this.source = unitBuilder.getSource();
        this.control = control;
        this.unitParameters = new HashSet<String>();
        for (String param : unitBuilder.getParameters()) {
            this.unitParameters.add(param.toLowerCase());
        }
    }

    public void finish() {
        this.source.prepend(this.initializations());
    }

    private String initializations() {
        JavaSource initSource = new JavaSource();
        for (VariableDescriptor descriptor : this.analyzer.allVariables()) {
            this.initVariable(descriptor, initSource);
        }
        return initSource.toString();
    }

    private void initVariable(VariableDescriptor descriptor, JavaSource initSource) {
        VariableScope scope = descriptor.getScope();
        if (scope == VariableScope.DYNAMIC) {
            initSource.beginAssignment(descriptor.getAssignedName());
            if (descriptor.isTemplateVariable()) {
                initSource.startCall("getProperty");
            } else if (this.unitParameters.contains(descriptor.getOriginalName().toLowerCase())) {
                initSource.startMethodCall("arguments", "get");
            } else {
                initSource.startMethodCall("bindings", "get");
            }
            initSource.stringLiteral(descriptor.getOriginalName()).endCall().endStatement();
        } else if (scope == VariableScope.GLOBAL) {
            initSource.beginAssignment(descriptor.getAssignedName()).nullLiteral().endStatement();
        }
        String listCoercionVar = descriptor.getListCoercion();
        if (listCoercionVar != null) {
            initSource.beginAssignment(listCoercionVar, "Collection").nullLiteral().endStatement();
        }
    }

    public void visit(Conditional.Start conditional) {
        VariableDescriptor descriptor = this.analyzer.descriptor(conditional.getVariable());
        boolean negate = !conditional.getExpectedTruthValue();
        this.source.beginIf();
        if (negate) {
            this.source.negation();
        }
        if (descriptor.getType() == Type.BOOLEAN) {
            this.source.append(descriptor.getAssignedName());
        } else {
            this.source.objectModel().startCall("toBoolean", true).append(descriptor.getAssignedName()).endCall();
        }
        this.source.completeIf();
    }

    public void visit(Conditional.End conditionalEnd) {
        this.source.endIf();
    }

    public void visit(VariableBinding.Start variableBinding) {
        this.source.startBlock();
        TypeInfo typeInfo = TypeInference.inferTypes(variableBinding.getExpression(), this.analyzer, this.unitBuilder.getImports(), this.unitBuilder.getJavaImportsAnalyzer());
        Type type = typeInfo.typeOf(variableBinding.getExpression());
        String properName = this.declare(variableBinding.getVariableName(), type);
        this.source.beginAssignment(properName, type.getNativeClass());
        ExpressionTranslator.buildExpression(variableBinding.getExpression(), this.source, this.analyzer, typeInfo, this.unitBuilder.getImports());
        this.source.endStatement();
    }

    public void visit(VariableBinding.End variableBindingEnd) {
        VariableDescriptor descriptor = this.analyzer.endVariable();
        String listCoercionVar = descriptor.getListCoercion();
        if (listCoercionVar != null) {
            this.generateCoercionClearing(listCoercionVar);
        }
        this.source.endBlock();
    }

    public void visit(VariableBinding.Global globalAssignment) {
        TypeInfo typeInfo = TypeInference.inferTypes(globalAssignment.getExpression(), this.analyzer, this.unitBuilder.getImports(), this.unitBuilder.getJavaImportsAnalyzer());
        VariableDescriptor descriptor = this.analyzer.declareGlobal(globalAssignment.getVariableName());
        String name = descriptor.getAssignedName();
        this.source.append(name).assign();
        ExpressionTranslator.buildExpression(globalAssignment.getExpression(), this.source, this.analyzer, typeInfo, this.unitBuilder.getImports());
        this.source.endStatement();
        String listCoercionVar = descriptor.getListCoercion();
        if (listCoercionVar != null) {
            this.generateCoercionClearing(listCoercionVar);
        }
    }

    public void visit(OutputVariable outputVariable) {
        String variable = this.analyzer.assignedName(outputVariable.getVariableName());
        this.source.startStatement().startMethodCall("out", "write").objectModel().startCall("toString", true).append(variable).endCall().endCall().endStatement();
    }

    public void visit(OutText outText) {
        this.source.startStatement().startMethodCall("out", "write").stringLiteral(outText.getText()).endCall().endStatement();
    }

    public void visit(Loop.Start loop) {
        VariableDescriptor descriptor = this.analyzer.descriptor(loop.getListVariable());
        String listVariable = descriptor.getAssignedName();
        String collectionVar = descriptor.requireListCoercion();
        this.source.beginIf().append(collectionVar).equality().nullLiteral().completeIf().startStatement().append(collectionVar).assign().objectModel().startCall("toCollection", true).append(listVariable).endCall().endStatement().endIf();
        String indexVar = this.declare(loop.getIndexVariable(), Type.LONG);
        this.source.beginAssignment(indexVar, Type.LONG.getNativeClass()).number(0).endStatement();
        String itemVar = this.declare(loop.getItemVariable(), Type.UNKNOWN);
        this.source.beginFor(itemVar, collectionVar);
        this.loopStatusStack.push(indexVar);
    }

    public void visit(Loop.End loopEnd) {
        String indexVar = this.loopStatusStack.pop();
        this.source.startStatement().append(indexVar).increment().endStatement();
        this.source.endFor();
        this.analyzer.endVariable();
        this.analyzer.endVariable();
    }

    public void visit(Procedure.Start startProcedure) {
        UnitBuilder subTemplateUnit = this.unitBuilder.newSubBuilder(startProcedure.getName(), startProcedure.getParameters());
        this.analyzer.declareTemplate(startProcedure.getName());
        this.control.push((CommandVisitor)new CodeGenVisitor(subTemplateUnit, this.control));
    }

    public void visit(Procedure.End endProcedure) {
        CodeGenVisitor previous = (CodeGenVisitor)this.control.pop();
        previous.finish();
    }

    public void visit(Procedure.Call procedureCall) {
        String templateVar = this.analyzer.assignedName(procedureCall.getTemplateVariable());
        String argVar = this.analyzer.assignedName(procedureCall.getArgumentsVariable());
        this.source.startStatement().startCall("callUnit", false).append("out").separateArgument().append("renderContext").separateArgument().append(templateVar).separateArgument().append(argVar).endCall().endStatement();
    }

    private String declare(String originalName, Type type) {
        return this.analyzer.declareVariable(originalName, type).getAssignedName();
    }

    private void generateCoercionClearing(String coercionVariableName) {
        this.source.startStatement().append(coercionVariableName).assign().nullLiteral().endStatement();
    }
}

