/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.testing.mock.caconfig;

import org.apache.sling.caconfig.impl.ConfigurationBuilderAdapterFactory;
import org.apache.sling.caconfig.impl.ConfigurationResolverImpl;
import org.apache.sling.caconfig.impl.def.DefaultConfigurationPersistenceStrategy;
import org.apache.sling.caconfig.impl.metadata.AnnotationClassConfigurationMetadataProvider;
import org.apache.sling.caconfig.management.impl.ConfigurationManagerImpl;
import org.apache.sling.caconfig.management.impl.ContextPathStrategyMultiplexerImpl;
import org.apache.sling.caconfig.resource.impl.ConfigurationResourceResolverImpl;
import org.apache.sling.caconfig.resource.impl.def.DefaultConfigurationResourceResolvingStrategy;
import org.apache.sling.caconfig.resource.impl.def.DefaultContextPathStrategy;
import org.apache.sling.testing.mock.caconfig.ConfigurationMetadataUtil;
import org.apache.sling.testing.mock.osgi.context.AbstractContextPlugin;
import org.apache.sling.testing.mock.osgi.context.ContextPlugin;
import org.apache.sling.testing.mock.sling.context.SlingContextImpl;
import org.jetbrains.annotations.NotNull;
import org.osgi.annotation.versioning.ProviderType;

@ProviderType
public final class ContextPlugins {
    @NotNull
    public static final ContextPlugin<? extends SlingContextImpl> CACONFIG = new AbstractContextPlugin<SlingContextImpl>(){

        public void beforeSetUp(@NotNull SlingContextImpl context) throws Exception {
            ContextPlugins.registerConfigurationResourceResolver(context);
            ContextPlugins.registerConfigurationResolver(context);
            ContextPlugins.registerConfigurationManagement(context);
            ContextPlugins.registerModelsInjector(context);
        }

        public void afterSetUp(@NotNull SlingContextImpl context) throws Exception {
            ContextPlugins.registerConfigurationResourceResolverDefaultImpl(context);
            ContextPlugins.registerConfigurationResolverDefaultImpl(context);
            ConfigurationMetadataUtil.addAnnotationClassesForManifestEntries(context.bundleContext());
        }
    };
    @NotNull
    public static final ContextPlugin<? extends SlingContextImpl> CACONFIG_NODEF = new AbstractContextPlugin<SlingContextImpl>(){

        public void afterSetUp(@NotNull SlingContextImpl context) throws Exception {
            ContextPlugins.registerConfigurationResourceResolver(context);
            ContextPlugins.registerConfigurationResolver(context);
            ContextPlugins.registerConfigurationManagement(context);
            ContextPlugins.registerModelsInjector(context);
        }
    };

    private ContextPlugins() {
    }

    private static void registerConfigurationResourceResolver(SlingContextImpl context) {
        context.registerInjectActivateService((Object)new ContextPathStrategyMultiplexerImpl());
        if (!ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.resource.impl.ConfigurationResourceResolvingStrategyMultiplexerImpl")) {
            ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.resource.impl.ConfigurationResourceResolvingStrategyMultiplexer");
        }
        context.registerInjectActivateService((Object)new ConfigurationResourceResolverImpl());
    }

    private static void registerConfigurationResourceResolverDefaultImpl(SlingContextImpl context) {
        context.registerInjectActivateService((Object)new DefaultContextPathStrategy());
        context.registerInjectActivateService((Object)new DefaultConfigurationResourceResolvingStrategy());
    }

    private static void registerConfigurationResolver(SlingContextImpl context) {
        ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.management.impl.ConfigurationManagementSettingsImpl");
        if (!ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.management.impl.ConfigurationPersistenceStrategyMultiplexerImpl")) {
            ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.management.impl.ConfigurationPersistenceStrategyMultiplexer");
        }
        ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.impl.ConfigurationPersistenceStrategyBridge");
        if (!ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.impl.metadata.ConfigurationMetadataProviderMultiplexerImpl")) {
            ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.impl.metadata.ConfigurationMetadataProviderMultiplexer");
        }
        if (!ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.impl.ConfigurationInheritanceStrategyMultiplexerImpl")) {
            ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.impl.ConfigurationInheritanceStrategyMultiplexer");
        }
        if (!ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.impl.override.ConfigurationOverrideMultiplexerImpl")) {
            ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.impl.override.ConfigurationOverrideManager");
        }
        context.registerInjectActivateService((Object)new ConfigurationResolverImpl());
        context.registerInjectActivateService((Object)new ConfigurationBuilderAdapterFactory());
    }

    private static void registerConfigurationResolverDefaultImpl(SlingContextImpl context) {
        context.registerInjectActivateService((Object)new DefaultConfigurationPersistenceStrategy());
        ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.impl.def.DefaultConfigurationInheritanceStrategy");
        ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.impl.def.DefaultConfigurationInjectResourceDetectionStrategy");
    }

    private static void registerConfigurationManagement(SlingContextImpl context) {
        context.registerInjectActivateService((Object)new ConfigurationManagerImpl());
        context.registerInjectActivateService((Object)new AnnotationClassConfigurationMetadataProvider());
        ContextPlugins.registerByClassName(context, "org.apache.sling.caconfig.impl.ConfigurationInjectResourceDetectionStrategyMultiplexerImpl");
    }

    private static void registerModelsInjector(SlingContextImpl context) {
        ContextPlugins.registerByClassName(context, "org.apache.sling.models.caconfig.impl.injectors.ContextAwareConfigurationInjector");
    }

    private static boolean registerByClassName(SlingContextImpl context, String className) {
        try {
            Class<?> clazz = Class.forName(className);
            context.registerInjectActivateService(clazz.newInstance());
            return true;
        }
        catch (ClassNotFoundException ex) {
            return false;
        }
        catch (InstantiationException ex) {
            throw new RuntimeException(ex);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(ex);
        }
    }
}

