/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.cp;

import org.apache.sysml.api.DMLScript;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLScriptException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.instructions.cp.BooleanObject;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.cp.DoubleObject;
import org.apache.sysml.runtime.instructions.cp.IntObject;
import org.apache.sysml.runtime.instructions.cp.ScalarObject;
import org.apache.sysml.runtime.instructions.cp.StringObject;
import org.apache.sysml.runtime.instructions.cp.UnaryMatrixCPInstruction;
import org.apache.sysml.runtime.matrix.operators.Operator;
import org.apache.sysml.runtime.matrix.operators.UnaryOperator;

public class UnaryScalarCPInstruction
extends UnaryMatrixCPInstruction {
    protected UnaryScalarCPInstruction(Operator op, CPOperand in, CPOperand out, String opcode, String instr) {
        super(op, in, out, opcode, instr);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        String opcode = this.getOpcode();
        ScalarObject sores = null;
        ScalarObject so = null;
        so = ec.getScalarInput(this.input1.getName(), this.input1.getValueType(), this.input1.isLiteral());
        if (opcode.equalsIgnoreCase("print")) {
            String outString = so.getLanguageSpecificStringValue();
            if (!DMLScript.suppressPrint2Stdout()) {
                System.out.println(outString);
            }
            sores = new StringObject(outString);
        } else {
            if (opcode.equalsIgnoreCase("stop")) {
                throw new DMLScriptException(so.getStringValue());
            }
            if (opcode.equalsIgnoreCase("assert")) {
                sores = new BooleanObject(so.getBooleanValue());
                if (!so.getBooleanValue()) {
                    String fileName = this.getFilename() == null ? "" : this.getFilename() + " ";
                    throw new DMLScriptException("assertion failed at " + fileName + this.getBeginLine() + ":" + this.getBeginColumn() + "-" + this.getEndLine() + ":" + this.getEndColumn());
                }
            } else {
                UnaryOperator dop = (UnaryOperator)this._optr;
                sores = so instanceof IntObject && this.output.getValueType() == Expression.ValueType.INT ? new IntObject((long)dop.fn.execute(so.getLongValue())) : (so instanceof BooleanObject && this.output.getValueType() == Expression.ValueType.BOOLEAN ? new BooleanObject(dop.fn.execute(so.getBooleanValue())) : new DoubleObject(dop.fn.execute(so.getDoubleValue())));
            }
        }
        ec.setScalarOutput(this.output.getName(), sores);
    }
}

