/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.instructions.spark;

import java.util.Iterator;
import java.util.List;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.function.Function;
import org.apache.spark.api.java.function.PairFlatMapFunction;
import org.apache.sysml.parser.Expression;
import org.apache.sysml.runtime.DMLRuntimeException;
import org.apache.sysml.runtime.controlprogram.context.ExecutionContext;
import org.apache.sysml.runtime.controlprogram.context.SparkExecutionContext;
import org.apache.sysml.runtime.instructions.InstructionUtils;
import org.apache.sysml.runtime.instructions.cp.CPOperand;
import org.apache.sysml.runtime.instructions.spark.SPInstruction;
import org.apache.sysml.runtime.instructions.spark.UnarySPInstruction;
import org.apache.sysml.runtime.instructions.spark.functions.FilterNonEmptyBlocksFunction;
import org.apache.sysml.runtime.instructions.spark.utils.RDDAggregateUtils;
import org.apache.sysml.runtime.instructions.spark.utils.SparkUtils;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.LibMatrixReorg;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.mapred.IndexedMatrixValue;
import org.apache.sysml.runtime.matrix.operators.Operator;
import scala.Tuple2;

public class MatrixReshapeSPInstruction
extends UnarySPInstruction {
    private final CPOperand _opRows;
    private final CPOperand _opCols;
    private final CPOperand _opByRow;
    private final boolean _outputEmptyBlocks;

    private MatrixReshapeSPInstruction(Operator op, CPOperand in1, CPOperand in2, CPOperand in3, CPOperand in4, CPOperand out, boolean outputEmptyBlocks, String opcode, String istr) {
        super(SPInstruction.SPType.MatrixReshape, op, in1, out, opcode, istr);
        this._opRows = in2;
        this._opCols = in3;
        this._opByRow = in4;
        this._outputEmptyBlocks = outputEmptyBlocks;
    }

    public static MatrixReshapeSPInstruction parseInstruction(String str) {
        String[] parts = InstructionUtils.getInstructionPartsWithValueType(str);
        InstructionUtils.checkNumFields(parts, 6);
        String opcode = parts[0];
        CPOperand in1 = new CPOperand(parts[1]);
        CPOperand in2 = new CPOperand(parts[2]);
        CPOperand in3 = new CPOperand(parts[3]);
        CPOperand in4 = new CPOperand(parts[4]);
        CPOperand out = new CPOperand(parts[5]);
        boolean outputEmptyBlocks = Boolean.parseBoolean(parts[6]);
        if (!opcode.equalsIgnoreCase("rshape")) {
            throw new DMLRuntimeException("Unknown opcode while parsing an MatrixReshapeInstruction: " + str);
        }
        return new MatrixReshapeSPInstruction(new Operator(true), in1, in2, in3, in4, out, outputEmptyBlocks, opcode, str);
    }

    @Override
    public void processInstruction(ExecutionContext ec) {
        SparkExecutionContext sec = (SparkExecutionContext)ec;
        long rows = ec.getScalarInput(this._opRows.getName(), this._opRows.getValueType(), this._opRows.isLiteral()).getLongValue();
        long cols = ec.getScalarInput(this._opCols.getName(), this._opCols.getValueType(), this._opCols.isLiteral()).getLongValue();
        boolean byRow = ec.getScalarInput(this._opByRow.getName(), Expression.ValueType.BOOLEAN, this._opByRow.isLiteral()).getBooleanValue();
        JavaPairRDD in1 = sec.getBinaryBlockRDDHandleForVariable(this.input1.getName(), -1, this._outputEmptyBlocks);
        MatrixCharacteristics mcIn = sec.getMatrixCharacteristics(this.input1.getName());
        MatrixCharacteristics mcOut = sec.getMatrixCharacteristics(this.output.getName());
        mcOut.set(rows, cols, mcIn.getRowsPerBlock(), mcIn.getColsPerBlock(), mcIn.getNonZeros());
        if (!mcIn.nnzKnown()) {
            mcOut.setNonZerosBound(mcIn.getNonZerosBound());
        }
        if (mcIn.getRows() * mcIn.getCols() != mcOut.getRows() * mcOut.getCols()) {
            throw new DMLRuntimeException("Incompatible matrix characteristics for reshape: " + mcIn.getRows() + "x" + mcIn.getCols() + " vs " + mcOut.getRows() + "x" + mcOut.getCols());
        }
        if (!this._outputEmptyBlocks) {
            in1 = in1.filter((Function)new FilterNonEmptyBlocksFunction());
        }
        JavaPairRDD<MatrixIndexes, MatrixBlock> out = in1.flatMapToPair((PairFlatMapFunction)new RDDReshapeFunction(mcIn, mcOut, byRow, this._outputEmptyBlocks));
        out = RDDAggregateUtils.mergeByKey(out);
        sec.setRDDHandleForVariable(this.output.getName(), out);
        sec.addLineageRDD(this.output.getName(), this.input1.getName());
    }

    private static class RDDReshapeFunction
    implements PairFlatMapFunction<Tuple2<MatrixIndexes, MatrixBlock>, MatrixIndexes, MatrixBlock> {
        private static final long serialVersionUID = 2819309412002224478L;
        private final MatrixCharacteristics _mcIn;
        private final MatrixCharacteristics _mcOut;
        private final boolean _byrow;
        private final boolean _outputEmptyBlocks;

        public RDDReshapeFunction(MatrixCharacteristics mcIn, MatrixCharacteristics mcOut, boolean byrow, boolean outputEmptyBlocks) {
            this._mcIn = mcIn;
            this._mcOut = mcOut;
            this._byrow = byrow;
            this._outputEmptyBlocks = outputEmptyBlocks;
        }

        public Iterator<Tuple2<MatrixIndexes, MatrixBlock>> call(Tuple2<MatrixIndexes, MatrixBlock> arg0) throws Exception {
            IndexedMatrixValue in = SparkUtils.toIndexedMatrixBlock(arg0);
            List<IndexedMatrixValue> out = LibMatrixReorg.reshape(in, this._mcIn, this._mcOut, this._byrow, this._outputEmptyBlocks);
            return SparkUtils.fromIndexedMatrixBlock(out).iterator();
        }
    }
}

