/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix;

import java.util.HashSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.sysml.conf.ConfigurationManager;
import org.apache.sysml.conf.DMLConfig;
import org.apache.sysml.runtime.instructions.MRJobInstruction;
import org.apache.sysml.runtime.matrix.JobReturn;
import org.apache.sysml.runtime.matrix.MatrixCharacteristics;
import org.apache.sysml.runtime.matrix.data.CM_N_COVCell;
import org.apache.sysml.runtime.matrix.data.InputInfo;
import org.apache.sysml.runtime.matrix.data.OutputInfo;
import org.apache.sysml.runtime.matrix.data.TaggedFirstSecondIndexes;
import org.apache.sysml.runtime.matrix.mapred.CMCOVMRMapper;
import org.apache.sysml.runtime.matrix.mapred.CMCOVMRReducer;
import org.apache.sysml.runtime.matrix.mapred.MRJobConfiguration;

public class CMCOVMR {
    private static final Log LOG = LogFactory.getLog((String)CMCOVMR.class.getName());

    private CMCOVMR() {
    }

    public static JobReturn runJob(MRJobInstruction inst, String[] inputs, InputInfo[] inputInfos, long[] rlens, long[] clens, int[] brlens, int[] bclens, String instructionsInMapper, String cmNcomInstructions, int numReducers, int replication, byte[] resultIndexes, String[] outputs, OutputInfo[] outputInfos) throws Exception {
        JobConf job = new JobConf(CMCOVMR.class);
        job.setJobName("CM-COV-MR");
        MRJobConfiguration.setMatrixValueClassForCM_N_COM(job, true);
        String[] realinputs = inputs;
        InputInfo[] realinputInfos = inputInfos;
        long[] realrlens = rlens;
        long[] realclens = clens;
        int[] realbrlens = brlens;
        int[] realbclens = bclens;
        byte[] realIndexes = new byte[inputs.length];
        for (int b = 0; b < realIndexes.length; b = (int)((byte)(b + 1))) {
            realIndexes[b] = b;
        }
        MRJobConfiguration.setUpMultipleInputs(job, realIndexes, realinputs, realinputInfos, realbrlens, realbclens, true, MRJobConfiguration.ConvertTarget.WEIGHTEDCELL);
        MRJobConfiguration.setMatricesDimensions(job, realIndexes, realrlens, realclens);
        MRJobConfiguration.setBlocksSizes(job, realIndexes, realbrlens, realbclens);
        MRJobConfiguration.setInstructionsInMapper(job, instructionsInMapper);
        MRJobConfiguration.setCM_N_COMInstructions(job, cmNcomInstructions);
        job.setInt("dfs.replication", replication);
        DMLConfig config = ConfigurationManager.getDMLConfig();
        MRJobConfiguration.setupCustomMRConfigurations(job, config);
        HashSet<Byte> mapoutputIndexes = MRJobConfiguration.setUpOutputIndexesForMapper(job, realIndexes, instructionsInMapper, null, cmNcomInstructions, resultIndexes);
        MRJobConfiguration.setUpMultipleOutputs(job, resultIndexes, new byte[resultIndexes.length], outputs, outputInfos, false);
        job.setMapperClass(CMCOVMRMapper.class);
        job.setMapOutputKeyClass(TaggedFirstSecondIndexes.class);
        job.setMapOutputValueClass(CM_N_COVCell.class);
        job.setOutputKeyComparatorClass(TaggedFirstSecondIndexes.Comparator.class);
        job.setPartitionerClass(TaggedFirstSecondIndexes.TagPartitioner.class);
        job.setReducerClass(CMCOVMRReducer.class);
        MatrixCharacteristics[] stats = MRJobConfiguration.computeMatrixCharacteristics((JobConf)job, (byte[])realIndexes, (String)instructionsInMapper, null, null, (String)cmNcomInstructions, (byte[])resultIndexes, mapoutputIndexes, (boolean)false).stats;
        MRJobConfiguration.setNumReducers(job, mapoutputIndexes.size(), numReducers);
        if (LOG.isTraceEnabled()) {
            inst.printCompleteMRJobInstruction(stats);
        }
        MatrixCharacteristics[] inputStats = new MatrixCharacteristics[inputs.length];
        for (int i = 0; i < inputs.length; ++i) {
            inputStats[i] = new MatrixCharacteristics(rlens[i], clens[i], brlens[i], bclens[i]);
        }
        MRJobConfiguration.setUniqueWorkingDir(job);
        RunningJob runjob = JobClient.runJob((JobConf)job);
        return new JobReturn(stats, outputInfos, runjob.isSuccessful());
    }
}

