/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sysml.runtime.matrix.data;

import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.Writable;
import org.apache.sysml.runtime.matrix.data.BinaryBlockToBinaryCellConverter;
import org.apache.sysml.runtime.matrix.data.Converter;
import org.apache.sysml.runtime.matrix.data.IdenticalConverter;
import org.apache.sysml.runtime.matrix.data.MatrixBlock;
import org.apache.sysml.runtime.matrix.data.MatrixCell;
import org.apache.sysml.runtime.matrix.data.MatrixIndexes;
import org.apache.sysml.runtime.matrix.data.Pair;
import org.apache.sysml.runtime.matrix.data.TextToBinaryCellConverter;
import org.apache.sysml.runtime.matrix.data.WeightedPair;

public class AddDummyWeightConverter
implements Converter<Writable, Writable, MatrixIndexes, WeightedPair> {
    private Converter toCellConverter = null;
    private WeightedPair outValue = new WeightedPair();
    private Pair<MatrixIndexes, WeightedPair> pair = new Pair();
    private int rlen;
    private int clen;

    public AddDummyWeightConverter() {
        this.outValue.setWeight(1.0);
        this.outValue.setOtherValue(0.0);
        this.pair.setValue(this.outValue);
    }

    @Override
    public void convert(Writable k1, Writable v1) {
        if (this.toCellConverter == null) {
            this.toCellConverter = v1 instanceof Text ? new TextToBinaryCellConverter() : (v1 instanceof MatrixBlock ? new BinaryBlockToBinaryCellConverter() : new IdenticalConverter());
            this.toCellConverter.setBlockSize(this.rlen, this.clen);
        }
        this.toCellConverter.convert(k1, v1);
    }

    @Override
    public boolean hasNext() {
        return this.toCellConverter.hasNext();
    }

    @Override
    public Pair<MatrixIndexes, WeightedPair> next() {
        Pair temp = this.toCellConverter.next();
        this.pair.setKey((MatrixIndexes)temp.getKey());
        this.outValue.setValue(((MatrixCell)temp.getValue()).getValue());
        return this.pair;
    }

    @Override
    public void setBlockSize(int rl, int cl) {
        if (this.toCellConverter == null) {
            this.rlen = rl;
            this.clen = cl;
        } else {
            this.toCellConverter.setBlockSize(rl, cl);
        }
    }
}

